/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;

public class StringGroupConcatColCol
extends VectorExpression {
    private static final long serialVersionUID = 1L;
    private int colNum1;
    private int colNum2;
    private int outputColumn;

    public StringGroupConcatColCol(int colNum1, int colNum2, int outputColumn) {
        this();
        this.colNum1 = colNum1;
        this.colNum2 = colNum2;
        this.outputColumn = outputColumn;
    }

    public StringGroupConcatColCol() {
    }

    @Override
    public void evaluate(VectorizedRowBatch batch) {
        if (this.childExpressions != null) {
            super.evaluateChildren(batch);
        }
        BytesColumnVector inV1 = (BytesColumnVector)batch.cols[this.colNum1];
        BytesColumnVector inV2 = (BytesColumnVector)batch.cols[this.colNum2];
        BytesColumnVector outV = (BytesColumnVector)batch.cols[this.outputColumn];
        int[] sel = batch.selected;
        int n = batch.size;
        byte[][] vector1 = inV1.vector;
        byte[][] vector2 = inV2.vector;
        int[] len1 = inV1.length;
        int[] len2 = inV2.length;
        int[] start1 = inV1.start;
        int[] start2 = inV2.start;
        if (n == 0) {
            return;
        }
        outV.initBuffer();
        outV.isRepeating = false;
        if (inV1.noNulls && !inV2.noNulls) {
            outV.noNulls = false;
            if (inV2.isRepeating) {
                if (inV2.isNull[0]) {
                    outV.isNull[0] = true;
                    outV.isRepeating = true;
                    return;
                }
            } else {
                StringGroupConcatColCol.propagateNulls(batch.selectedInUse, n, sel, (ColumnVector)inV2, (ColumnVector)outV);
            }
            if (inV1.isRepeating && inV2.isRepeating) {
                if (!inV2.isNull[0]) {
                    outV.setConcat(0, vector1[0], start1[0], len1[0], vector2[0], start2[0], len2[0]);
                }
                outV.isRepeating = true;
            } else if (inV1.isRepeating) {
                if (batch.selectedInUse) {
                    for (int j = 0; j != n; ++j) {
                        int i = sel[j];
                        if (inV2.isNull[i]) continue;
                        outV.setConcat(i, vector1[0], start1[0], len1[0], vector2[i], start2[i], len2[i]);
                    }
                } else {
                    for (int i = 0; i != n; ++i) {
                        if (inV2.isNull[0]) continue;
                        outV.setConcat(i, vector1[0], start1[0], len1[0], vector2[i], start2[i], len2[i]);
                    }
                }
            } else if (inV2.isRepeating) {
                if (batch.selectedInUse) {
                    for (int j = 0; j != n; ++j) {
                        int i = sel[j];
                        if (inV2.isNull[i]) continue;
                        outV.setConcat(i, vector1[i], start1[i], len1[i], vector2[0], start2[0], len2[0]);
                    }
                } else {
                    for (int i = 0; i != n; ++i) {
                        if (inV2.isNull[i]) continue;
                        outV.setConcat(i, vector1[i], start1[i], len1[i], vector2[0], start2[0], len2[0]);
                    }
                }
            } else if (batch.selectedInUse) {
                for (int j = 0; j != n; ++j) {
                    int i = sel[j];
                    if (inV2.isNull[i]) continue;
                    outV.setConcat(i, vector1[i], start1[i], len1[i], vector2[i], start2[i], len2[i]);
                }
            } else {
                for (int i = 0; i != n; ++i) {
                    if (inV2.isNull[i]) continue;
                    outV.setConcat(i, vector1[i], start1[i], len1[i], vector2[i], start2[i], len2[i]);
                }
            }
        } else if (!inV1.noNulls && inV2.noNulls) {
            outV.noNulls = false;
            if (inV1.isRepeating) {
                outV.isRepeating = true;
                outV.isNull[0] = true;
                return;
            }
            StringGroupConcatColCol.propagateNulls(batch.selectedInUse, n, sel, (ColumnVector)inV1, (ColumnVector)outV);
            if (inV1.isRepeating && inV2.isRepeating) {
                if (!inV1.isNull[0]) {
                    outV.setConcat(0, vector1[0], start1[0], len1[0], vector2[0], start2[0], len2[0]);
                }
                outV.isRepeating = true;
            } else if (inV1.isRepeating) {
                if (batch.selectedInUse) {
                    for (int j = 0; j != n; ++j) {
                        int i = sel[j];
                        if (inV1.isNull[0]) continue;
                        outV.setConcat(i, vector1[0], start1[0], len1[0], vector2[i], start2[i], len2[i]);
                    }
                } else {
                    for (int i = 0; i != n; ++i) {
                        if (inV1.isNull[0]) continue;
                        outV.setConcat(i, vector1[0], start1[0], len1[0], vector2[i], start2[i], len2[i]);
                    }
                }
            } else if (inV2.isRepeating) {
                if (batch.selectedInUse) {
                    for (int j = 0; j != n; ++j) {
                        int i = sel[j];
                        if (inV1.isNull[i]) continue;
                        outV.setConcat(i, vector1[i], start1[i], len1[i], vector2[0], start2[0], len2[0]);
                    }
                } else {
                    for (int i = 0; i != n; ++i) {
                        if (inV1.isNull[i]) continue;
                        outV.setConcat(i, vector1[i], start1[i], len1[i], vector2[0], start2[0], len2[0]);
                    }
                }
            } else if (batch.selectedInUse) {
                for (int j = 0; j != n; ++j) {
                    int i = sel[j];
                    if (inV1.isNull[i]) continue;
                    outV.setConcat(i, vector1[i], start1[i], len1[i], vector2[i], start2[i], len2[i]);
                }
            } else {
                for (int i = 0; i != n; ++i) {
                    if (inV1.isNull[i]) continue;
                    outV.setConcat(i, vector1[i], start1[i], len1[i], vector2[i], start2[i], len2[i]);
                }
            }
        } else if (!inV1.noNulls && !inV2.noNulls) {
            outV.noNulls = false;
            if (inV1.isRepeating && inV2.isRepeating) {
                outV.isNull[0] = inV1.isNull[0] || inV2.isNull[0];
                outV.isRepeating = true;
                if (outV.isNull[0]) {
                    return;
                }
            } else if (inV1.isRepeating) {
                if (inV1.isNull[0]) {
                    outV.isRepeating = true;
                    outV.isNull[0] = true;
                    return;
                }
                outV.isRepeating = false;
                StringGroupConcatColCol.propagateNulls(batch.selectedInUse, n, sel, (ColumnVector)inV2, (ColumnVector)outV);
            } else if (inV2.isRepeating) {
                if (inV2.isNull[0]) {
                    outV.isRepeating = true;
                    outV.isNull[0] = true;
                    return;
                }
                outV.isRepeating = false;
                StringGroupConcatColCol.propagateNulls(batch.selectedInUse, n, sel, (ColumnVector)inV1, (ColumnVector)outV);
            } else {
                StringGroupConcatColCol.propagateNullsCombine(batch.selectedInUse, n, sel, (ColumnVector)inV1, (ColumnVector)inV2, outV);
            }
            if (inV1.isRepeating && inV2.isRepeating) {
                if (!inV1.isNull[0] && !inV2.isNull[0]) {
                    outV.setConcat(0, vector1[0], start1[0], len1[0], vector2[0], start2[0], len2[0]);
                }
                outV.isRepeating = true;
            } else if (inV1.isRepeating) {
                if (batch.selectedInUse) {
                    for (int j = 0; j != n; ++j) {
                        int i = sel[j];
                        if (inV1.isNull[0] || inV2.isNull[i]) continue;
                        outV.setConcat(i, vector1[0], start1[0], len1[0], vector2[i], start2[i], len2[i]);
                    }
                } else {
                    for (int i = 0; i != n; ++i) {
                        if (inV1.isNull[0] || inV2.isNull[i]) continue;
                        outV.setConcat(i, vector1[0], start1[0], len1[0], vector2[i], start2[i], len2[i]);
                    }
                }
            } else if (inV2.isRepeating) {
                if (batch.selectedInUse) {
                    for (int j = 0; j != n; ++j) {
                        int i = sel[j];
                        if (inV1.isNull[i] || inV2.isNull[0]) continue;
                        outV.setConcat(i, vector1[i], start1[i], len1[i], vector2[0], start2[0], len2[0]);
                    }
                } else {
                    for (int i = 0; i != n; ++i) {
                        if (inV1.isNull[i] || inV2.isNull[0]) continue;
                        outV.setConcat(i, vector1[i], start1[i], len1[i], vector2[0], start2[0], len2[0]);
                    }
                }
            } else if (batch.selectedInUse) {
                for (int j = 0; j != n; ++j) {
                    int i = sel[j];
                    if (inV1.isNull[i] || inV2.isNull[i]) continue;
                    outV.setConcat(i, vector1[i], start1[i], len1[i], vector2[i], start2[i], len2[i]);
                }
            } else {
                for (int i = 0; i != n; ++i) {
                    if (inV1.isNull[i] || inV2.isNull[i]) continue;
                    outV.setConcat(i, vector1[i], start1[i], len1[i], vector2[i], start2[i], len2[i]);
                }
            }
        } else {
            outV.noNulls = true;
            if (inV1.isRepeating && inV2.isRepeating) {
                outV.setConcat(0, vector1[0], start1[0], len1[0], vector2[0], start2[0], len2[0]);
                outV.isRepeating = true;
            } else if (inV1.isRepeating) {
                if (batch.selectedInUse) {
                    for (int j = 0; j != n; ++j) {
                        int i = sel[j];
                        outV.setConcat(i, vector1[0], start1[0], len1[0], vector2[i], start2[i], len2[i]);
                    }
                } else {
                    for (int i = 0; i != n; ++i) {
                        outV.setConcat(i, vector1[0], start1[0], len1[0], vector2[i], start2[i], len2[i]);
                    }
                }
            } else if (inV2.isRepeating) {
                if (batch.selectedInUse) {
                    for (int j = 0; j != n; ++j) {
                        int i = sel[j];
                        outV.setConcat(i, vector1[i], start1[i], len1[i], vector2[0], start2[0], len2[0]);
                    }
                } else {
                    for (int i = 0; i != n; ++i) {
                        outV.setConcat(i, vector1[i], start1[i], len1[i], vector2[0], start2[0], len2[0]);
                    }
                }
            } else if (batch.selectedInUse) {
                for (int j = 0; j != n; ++j) {
                    int i = sel[j];
                    outV.setConcat(i, vector1[i], start1[i], len1[i], vector2[i], start2[i], len2[i]);
                }
            } else {
                for (int i = 0; i != n; ++i) {
                    outV.setConcat(i, vector1[i], start1[i], len1[i], vector2[i], start2[i], len2[i]);
                }
            }
        }
    }

    private static void propagateNullsCombine(boolean selectedInUse, int n, int[] sel, ColumnVector inV1, ColumnVector inV2, BytesColumnVector outV) {
        if (selectedInUse) {
            for (int j = 0; j != n; ++j) {
                int i = sel[j];
                outV.isNull[i] = inV1.isNull[i] || inV2.isNull[i];
            }
        } else {
            for (int i = 0; i != n; ++i) {
                outV.isNull[i] = inV1.isNull[i] || inV2.isNull[i];
            }
        }
    }

    private static void propagateNulls(boolean selectedInUse, int n, int[] sel, ColumnVector inV, ColumnVector outV) {
        if (selectedInUse) {
            for (int j = 0; j != n; ++j) {
                int i = sel[j];
                outV.isNull[i] = inV.isNull[i];
            }
        } else {
            System.arraycopy(inV.isNull, 0, outV.isNull, 0, n);
        }
    }

    @Override
    public int getOutputColumn() {
        return this.outputColumn;
    }

    @Override
    public String getOutputType() {
        return "String_Family";
    }

    public int getColNum1() {
        return this.colNum1;
    }

    public void setColNum1(int colNum1) {
        this.colNum1 = colNum1;
    }

    public int getColNum2() {
        return this.colNum2;
    }

    public void setColNum2(int colNum2) {
        this.colNum2 = colNum2;
    }

    public void setOutputColumn(int outputColumn) {
        this.outputColumn = outputColumn;
    }

    @Override
    public String vectorExpressionParameters() {
        return "col " + this.colNum1 + ", col " + this.colNum2;
    }

    @Override
    public VectorExpressionDescriptor.Descriptor getDescriptor() {
        return new VectorExpressionDescriptor.Builder().setMode(VectorExpressionDescriptor.Mode.PROJECTION).setNumArguments(2).setArgumentTypes(VectorExpressionDescriptor.ArgumentType.STRING_FAMILY, VectorExpressionDescriptor.ArgumentType.STRING_FAMILY).setInputExpressionTypes(VectorExpressionDescriptor.InputExpressionType.COLUMN, VectorExpressionDescriptor.InputExpressionType.COLUMN).build();
    }
}

