/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.sql.compile.CompilerContext;
import org.apache.derby.iapi.sql.dictionary.ConglomerateDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.sql.execute.ConstantAction;
import org.apache.derby.impl.sql.compile.DDLStatementNode;
import org.apache.derby.impl.sql.compile.TableName;

class DropTableNode
extends DDLStatementNode {
    private long conglomerateNumber;
    private int dropBehavior;
    private TableDescriptor td;

    DropTableNode(TableName tableName, int n, ContextManager contextManager) throws StandardException {
        super(tableName, contextManager);
        this.dropBehavior = n;
    }

    @Override
    public String toString() {
        return "";
    }

    @Override
    String statementToString() {
        return "DROP TABLE";
    }

    @Override
    public void bindStatement() throws StandardException {
        CompilerContext compilerContext = this.getCompilerContext();
        this.td = this.getTableDescriptor();
        this.conglomerateNumber = this.td.getHeapConglomerateId();
        ConglomerateDescriptor conglomerateDescriptor = this.td.getConglomerateDescriptor(this.conglomerateNumber);
        compilerContext.createDependency(this.td);
        compilerContext.createDependency(conglomerateDescriptor);
    }

    @Override
    public boolean referencesSessionSchema() throws StandardException {
        return this.isSessionSchema(this.td.getSchemaDescriptor());
    }

    @Override
    public ConstantAction makeConstantAction() throws StandardException {
        return this.getGenericConstantActionFactory().getDropTableConstantAction(this.getFullName(), this.getRelativeName(), this.getSchemaDescriptor(this.td.getTableType() != 3, true), this.conglomerateNumber, this.td.getUUID(), this.dropBehavior);
    }
}

