/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.r;

import java.io.Serializable;
import org.apache.spark.ml.Model;
import org.apache.spark.ml.Pipeline;
import org.apache.spark.ml.PipelineModel;
import org.apache.spark.ml.PipelineStage;
import org.apache.spark.ml.attribute.Attribute;
import org.apache.spark.ml.attribute.AttributeGroup$;
import org.apache.spark.ml.feature.RFormula;
import org.apache.spark.ml.feature.RFormulaModel;
import org.apache.spark.ml.r.RWrapperUtils$;
import org.apache.spark.ml.r.RandomForestRegressorWrapper;
import org.apache.spark.ml.regression.RandomForestRegressor;
import org.apache.spark.ml.util.MLReadable;
import org.apache.spark.ml.util.MLReader;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.types.StructType;
import scala.Array$;
import scala.Function1;
import scala.Predef$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;

public final class RandomForestRegressorWrapper$
implements MLReadable<RandomForestRegressorWrapper> {
    public static RandomForestRegressorWrapper$ MODULE$;

    static {
        new RandomForestRegressorWrapper$();
    }

    public RandomForestRegressorWrapper fit(Dataset<Row> data, String formula, int maxDepth, int maxBins, int numTrees, String impurity, int minInstancesPerNode, double minInfoGain, int checkpointInterval, String featureSubsetStrategy, String seed, double subsamplingRate, int maxMemoryInMB, boolean cacheNodeIds, boolean bootstrap) {
        RFormula rFormula = new RFormula().setFormula(formula);
        RWrapperUtils$.MODULE$.checkDataColumns(rFormula, data);
        Model rFormulaModel = rFormula.fit((Dataset)data);
        StructType schema = ((RFormulaModel)rFormulaModel).transform(data).schema();
        Attribute[] featureAttrs = (Attribute[])AttributeGroup$.MODULE$.fromStructField(schema.apply(((RFormulaModel)rFormulaModel).getFeaturesCol())).attributes().get();
        String[] features = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])featureAttrs)).map((Function1 & Serializable & scala.Serializable)x$1 -> (String)x$1.name().get(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        RandomForestRegressor rfr = ((RandomForestRegressor)new RandomForestRegressor().setMaxDepth(maxDepth).setMaxBins(maxBins).setNumTrees(numTrees).setImpurity(impurity).setMinInstancesPerNode(minInstancesPerNode).setMinInfoGain(minInfoGain).setCheckpointInterval(checkpointInterval).setFeatureSubsetStrategy(featureSubsetStrategy).setSubsamplingRate(subsamplingRate).setMaxMemoryInMB(maxMemoryInMB).setCacheNodeIds(cacheNodeIds).setFeaturesCol(rFormula.getFeaturesCol())).setBootstrap(bootstrap);
        Object object = seed != null && seed.length() > 0 ? rfr.setSeed(new StringOps(Predef$.MODULE$.augmentString(seed)).toLong()) : BoxedUnit.UNIT;
        Model pipeline = new Pipeline().setStages((PipelineStage[])((Object[])new PipelineStage[]{rFormulaModel, rfr})).fit((Dataset)data);
        return new RandomForestRegressorWrapper((PipelineModel)pipeline, formula, features);
    }

    @Override
    public MLReader<RandomForestRegressorWrapper> read() {
        return new RandomForestRegressorWrapper.RandomForestRegressorWrapperReader();
    }

    @Override
    public RandomForestRegressorWrapper load(String path) {
        return (RandomForestRegressorWrapper)MLReadable.load$(this, path);
    }

    private RandomForestRegressorWrapper$() {
        MODULE$ = this;
        MLReadable.$init$(this);
    }
}

