/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.history;

import java.io.Serializable;
import org.apache.spark.deploy.history.EventFilter;
import org.apache.spark.deploy.history.EventFilterBuilder;
import org.apache.spark.scheduler.SparkListener;
import org.apache.spark.scheduler.SparkListenerEvent;
import org.apache.spark.scheduler.SparkListenerJobStart;
import org.apache.spark.scheduler.SparkListenerStageSubmitted;
import org.apache.spark.scheduler.SparkListenerTaskStart;
import org.apache.spark.sql.execution.SQLExecution$;
import org.apache.spark.sql.execution.history.SQLLiveEntitiesEventFilter;
import org.apache.spark.sql.execution.ui.SparkListenerSQLExecutionEnd;
import org.apache.spark.sql.execution.ui.SparkListenerSQLExecutionStart;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.HashSet$;
import scala.collection.mutable.Set;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005-c!\u0002\r\u001a\u0001})\u0003\"B\u001a\u0001\t\u0003)\u0004b\u0002\u001d\u0001\u0005\u0004%I!\u000f\u0005\u0007\u001d\u0002\u0001\u000b\u0011\u0002\u001e\t\u000f=\u0003!\u0019!C\u0005!\"1A\f\u0001Q\u0001\nECq!\u0018\u0001C\u0002\u0013%a\f\u0003\u0004b\u0001\u0001\u0006Ia\u0018\u0005\bE\u0002\u0011\r\u0011\"\u0003Q\u0011\u0019\u0019\u0007\u0001)A\u0005#\"9A\r\u0001b\u0001\n\u0013)\u0007BB5\u0001A\u0003%a\r\u0003\u0004k\u0001\u0011\u0005\u0011d\u001b\u0005\u0007[\u0002!\t!\u00078\t\r=\u0004A\u0011A\ro\u0011\u0019\u0001\b\u0001\"\u0001\u001aW\"1\u0011\u000f\u0001C\u000139DQA\u001d\u0001\u0005BMDQ\u0001 \u0001\u0005BuDq!a\u0002\u0001\t\u0003\nI\u0001C\u0004\u0002\u0016\u0001!\t%a\u0006\t\u000f\u0005\r\u0002\u0001\"\u0003\u0002&!9\u0011Q\u0007\u0001\u0005\n\u0005]\u0002bBA!\u0001\u0011\u0005\u00131\t\u0002\u0016'FcUI^3oi\u001aKG\u000e^3s\u0005VLG\u000eZ3s\u0015\tQ2$A\u0004iSN$xN]=\u000b\u0005qi\u0012!C3yK\u000e,H/[8o\u0015\tqr$A\u0002tc2T!\u0001I\u0011\u0002\u000bM\u0004\u0018M]6\u000b\u0005\t\u001a\u0013AB1qC\u000eDWMC\u0001%\u0003\ry'oZ\n\u0004\u0001\u0019b\u0003CA\u0014+\u001b\u0005A#BA\u0015 \u0003%\u00198\r[3ek2,'/\u0003\u0002,Q\ti1\u000b]1sW2K7\u000f^3oKJ\u0004\"!L\u0019\u000e\u00039R!AG\u0018\u000b\u0005Az\u0012A\u00023fa2|\u00170\u0003\u00023]\t\u0011RI^3oi\u001aKG\u000e^3s\u0005VLG\u000eZ3s\u0003\u0019a\u0014N\\5u}\r\u0001A#\u0001\u001c\u0011\u0005]\u0002Q\"A\r\u0002'1Lg/Z#yK\u000e,H/[8o)>TuNY:\u0016\u0003i\u0002Ba\u000f\"E\u00116\tAH\u0003\u0002>}\u00059Q.\u001e;bE2,'BA A\u0003)\u0019w\u000e\u001c7fGRLwN\u001c\u0006\u0002\u0003\u0006)1oY1mC&\u00111\t\u0010\u0002\b\u0011\u0006\u001c\b.T1q!\t)e)D\u0001A\u0013\t9\u0005I\u0001\u0003M_:<\u0007cA\u001eJ\u0017&\u0011!\n\u0010\u0002\u0004'\u0016$\bCA#M\u0013\ti\u0005IA\u0002J]R\fA\u0003\\5wK\u0016CXmY;uS>tGk\u001c&pEN\u0004\u0013a\u00036pER{7\u000b^1hKN,\u0012!\u0015\t\u0005w\t[%\u000bE\u0002T5.s!\u0001\u0016-\u0011\u0005U\u0003U\"\u0001,\u000b\u0005]#\u0014A\u0002\u001fs_>$h(\u0003\u0002Z\u0001\u00061\u0001K]3eK\u001aL!AS.\u000b\u0005e\u0003\u0015\u0001\u00046pER{7\u000b^1hKN\u0004\u0013\u0001D:uC\u001e,Gk\u001c+bg.\u001cX#A0\u0011\tm\u00125\n\u0019\t\u0004w%#\u0015!D:uC\u001e,Gk\u001c+bg.\u001c\b%A\u0006ti\u0006<W\rV8S\t\u0012\u001b\u0018\u0001D:uC\u001e,Gk\u001c*E\tN\u0004\u0013AB:uC\u001e,7/F\u0001g!\rYtmS\u0005\u0003Qr\u0012q\u0001S1tQN+G/A\u0004ti\u0006<Wm\u001d\u0011\u0002#1Lg/Z*R\u0019\u0016CXmY;uS>t7/F\u0001m!\r\u0019&\fR\u0001\tY&4XMS8cgV\t!+\u0001\u0006mSZ,7\u000b^1hKN\f\u0011\u0002\\5wKR\u000b7o[:\u0002\u00111Lg/\u001a*E\tN\f!b\u001c8K_\n\u001cF/\u0019:u)\t!x\u000f\u0005\u0002Fk&\u0011a\u000f\u0011\u0002\u0005+:LG\u000fC\u0003y#\u0001\u0007\u00110\u0001\u0005k_\n\u001cF/\u0019:u!\t9#0\u0003\u0002|Q\t)2\u000b]1sW2K7\u000f^3oKJTuNY*uCJ$\u0018\u0001E8o'R\fw-Z*vE6LG\u000f^3e)\t!h\u0010\u0003\u0004\u0000%\u0001\u0007\u0011\u0011A\u0001\u000fgR\fw-Z*vE6LG\u000f^3e!\r9\u00131A\u0005\u0004\u0003\u000bA#aG*qCJ\\G*[:uK:,'o\u0015;bO\u0016\u001cVOY7jiR,G-A\u0006p]R\u000b7o[*uCJ$Hc\u0001;\u0002\f!9\u0011QB\nA\u0002\u0005=\u0011!\u0003;bg.\u001cF/\u0019:u!\r9\u0013\u0011C\u0005\u0004\u0003'A#AF*qCJ\\G*[:uK:,'\u000fV1tWN#\u0018M\u001d;\u0002\u0019=tw\n\u001e5fe\u00163XM\u001c;\u0015\u0007Q\fI\u0002C\u0004\u0002\u001cQ\u0001\r!!\b\u0002\u000b\u00154XM\u001c;\u0011\u0007\u001d\ny\"C\u0002\u0002\"!\u0012!c\u00159be.d\u0015n\u001d;f]\u0016\u0014XI^3oi\u0006\u0001rN\\#yK\u000e,H/[8o'R\f'\u000f\u001e\u000b\u0004i\u0006\u001d\u0002bBA\u000e+\u0001\u0007\u0011\u0011\u0006\t\u0005\u0003W\t\t$\u0004\u0002\u0002.)\u0019\u0011qF\u000e\u0002\u0005UL\u0017\u0002BA\u001a\u0003[\u0011ad\u00159be.d\u0015n\u001d;f]\u0016\u00148+\u0015'Fq\u0016\u001cW\u000f^5p]N#\u0018M\u001d;\u0002\u001d=tW\t_3dkRLwN\\#oIR\u0019A/!\u000f\t\u000f\u0005ma\u00031\u0001\u0002<A!\u00111FA\u001f\u0013\u0011\ty$!\f\u00039M\u0003\u0018M]6MSN$XM\\3s'FcU\t_3dkRLwN\\#oI\u0006a1M]3bi\u00164\u0015\u000e\u001c;feR\u0011\u0011Q\t\t\u0004[\u0005\u001d\u0013bAA%]\tYQI^3oi\u001aKG\u000e^3s\u0001")
public class SQLEventFilterBuilder
extends SparkListener
implements EventFilterBuilder {
    private final HashMap<Object, Set<Object>> liveExecutionToJobs = new HashMap();
    private final HashMap<Object, scala.collection.immutable.Set<Object>> jobToStages = new HashMap();
    private final HashMap<Object, Set<Object>> stageToTasks = new HashMap();
    private final HashMap<Object, scala.collection.immutable.Set<Object>> stageToRDDs = new HashMap();
    private final HashSet<Object> stages = new HashSet();

    private HashMap<Object, Set<Object>> liveExecutionToJobs() {
        return this.liveExecutionToJobs;
    }

    private HashMap<Object, scala.collection.immutable.Set<Object>> jobToStages() {
        return this.jobToStages;
    }

    private HashMap<Object, Set<Object>> stageToTasks() {
        return this.stageToTasks;
    }

    private HashMap<Object, scala.collection.immutable.Set<Object>> stageToRDDs() {
        return this.stageToRDDs;
    }

    private HashSet<Object> stages() {
        return this.stages;
    }

    public scala.collection.immutable.Set<Object> liveSQLExecutions() {
        return this.liveExecutionToJobs().keySet().toSet();
    }

    public scala.collection.immutable.Set<Object> liveJobs() {
        return ((TraversableOnce)this.liveExecutionToJobs().values().flatten((Function1)Predef$.MODULE$.$conforms())).toSet();
    }

    public scala.collection.immutable.Set<Object> liveStages() {
        return this.stageToRDDs().keySet().toSet();
    }

    public scala.collection.immutable.Set<Object> liveTasks() {
        return ((TraversableOnce)this.stageToTasks().values().flatten((Function1)Predef$.MODULE$.$conforms())).toSet();
    }

    public scala.collection.immutable.Set<Object> liveRDDs() {
        return ((TraversableOnce)this.stageToRDDs().values().flatten((Function1)Predef$.MODULE$.$conforms())).toSet();
    }

    public void onJobStart(SparkListenerJobStart jobStart) {
        String executionIdString = jobStart.properties().getProperty(SQLExecution$.MODULE$.EXECUTION_ID_KEY());
        if (executionIdString == null) {
            return;
        }
        long executionId = new StringOps(Predef$.MODULE$.augmentString(executionIdString)).toLong();
        int jobId = jobStart.jobId();
        Set jobsForExecution = (Set)this.liveExecutionToJobs().getOrElseUpdate((Object)BoxesRunTime.boxToLong((long)executionId), (Function0 & Serializable & scala.Serializable)() -> (HashSet)HashSet$.MODULE$.apply((Seq)Nil$.MODULE$));
        jobsForExecution.$plus$eq((Object)BoxesRunTime.boxToInteger((int)jobId));
        this.jobToStages().$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)jobStart.jobId())), (Object)jobStart.stageIds().toSet()));
        this.stages().$plus$plus$eq((TraversableOnce)jobStart.stageIds());
    }

    public void onStageSubmitted(SparkListenerStageSubmitted stageSubmitted) {
        int stageId = stageSubmitted.stageInfo().stageId();
        if (this.stages().contains((Object)BoxesRunTime.boxToInteger((int)stageId))) {
            this.stageToRDDs().put((Object)BoxesRunTime.boxToInteger((int)stageId), (Object)((TraversableOnce)stageSubmitted.stageInfo().rddInfos().map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1.id()), Seq$.MODULE$.canBuildFrom())).toSet());
            this.stageToTasks().getOrElseUpdate((Object)BoxesRunTime.boxToInteger((int)stageId), (Function0 & Serializable & scala.Serializable)() -> new HashSet());
            return;
        }
    }

    public void onTaskStart(SparkListenerTaskStart taskStart) {
        this.stageToTasks().get((Object)BoxesRunTime.boxToInteger((int)taskStart.stageId())).foreach((Function1 & Serializable & scala.Serializable)tasks -> (Set)tasks.$plus$eq((Object)BoxesRunTime.boxToLong((long)taskStart.taskInfo().taskId())));
    }

    public void onOtherEvent(SparkListenerEvent event) {
        SparkListenerEvent sparkListenerEvent = event;
        if (sparkListenerEvent instanceof SparkListenerSQLExecutionStart) {
            SparkListenerSQLExecutionStart sparkListenerSQLExecutionStart = (SparkListenerSQLExecutionStart)sparkListenerEvent;
            this.onExecutionStart(sparkListenerSQLExecutionStart);
            return;
        }
        if (sparkListenerEvent instanceof SparkListenerSQLExecutionEnd) {
            SparkListenerSQLExecutionEnd sparkListenerSQLExecutionEnd = (SparkListenerSQLExecutionEnd)sparkListenerEvent;
            this.onExecutionEnd(sparkListenerSQLExecutionEnd);
            return;
        }
    }

    private void onExecutionStart(SparkListenerSQLExecutionStart event) {
        this.liveExecutionToJobs().$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)event.executionId())), (Object)HashSet$.MODULE$.apply((Seq)Nil$.MODULE$)));
    }

    private void onExecutionEnd(SparkListenerSQLExecutionEnd event) {
        this.liveExecutionToJobs().remove((Object)BoxesRunTime.boxToLong((long)event.executionId())).foreach((Function1 & Serializable & scala.Serializable)jobs -> {
            Iterable stagesToDrop = (Iterable)((HashMap)this.jobToStages().filter((Function1 & Serializable & scala.Serializable)kv -> BoxesRunTime.boxToBoolean((boolean)jobs.contains((Object)BoxesRunTime.boxToInteger((int)kv._1$mcI$sp()))))).values().flatten((Function1)Predef$.MODULE$.$conforms());
            this.jobToStages().$minus$minus$eq((TraversableOnce)jobs);
            this.stages().$minus$minus$eq((TraversableOnce)stagesToDrop);
            this.stageToTasks().$minus$minus$eq((TraversableOnce)stagesToDrop);
            return (HashMap)this.stageToRDDs().$minus$minus$eq((TraversableOnce)stagesToDrop);
        });
    }

    public EventFilter createFilter() {
        return new SQLLiveEntitiesEventFilter(this.liveSQLExecutions(), this.liveJobs(), this.liveStages(), this.liveTasks(), this.liveRDDs());
    }
}

