/**
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
import type { AppRouteRecordRaw } from "@/types/router";
import { createRouter, createWebHistory } from "vue-router";
import { applyGuards } from "./guards";
import { routesDashboard } from "./dashboard";
import { routesMarketplace } from "./marketplace";
import { routesAlarm } from "./alarm";
import routesLayers from "./layer";
import { routesSettings } from "./settings";
import { routesNotFound } from "./notFound";
import { routesTrace } from "./trace";

/**
 * Combine all route configurations
 */
export const routes: AppRouteRecordRaw[] = [
  ...routesMarketplace,
  ...routesLayers,
  ...routesAlarm,
  ...routesDashboard,
  ...routesSettings,
  ...routesNotFound,
  ...routesTrace,
];

/**
 * Create router instance
 */
const router = createRouter({
  history: createWebHistory(import.meta.env.BASE_URL),
  routes: routes as any,
});

/**
 * Apply navigation guards
 */
applyGuards(router, routes);

export default router;
