/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.rest.requests;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.rest.requests.FetchScanTasksRequest;
import org.apache.iceberg.util.JsonUtil;

public class FetchScanTasksRequestParser {
    private static final String PLAN_TASK = "plan-task";

    private FetchScanTasksRequestParser() {
    }

    public static String toJson(FetchScanTasksRequest request) {
        return FetchScanTasksRequestParser.toJson(request, false);
    }

    public static String toJson(FetchScanTasksRequest request, boolean pretty) {
        return JsonUtil.generate(gen -> FetchScanTasksRequestParser.toJson(request, gen), pretty);
    }

    public static void toJson(FetchScanTasksRequest request, JsonGenerator gen) throws IOException {
        Preconditions.checkArgument((null != request ? 1 : 0) != 0, (Object)"Invalid fetchScanTasks request: null");
        gen.writeStartObject();
        gen.writeStringField(PLAN_TASK, request.planTask());
        gen.writeEndObject();
    }

    public static FetchScanTasksRequest fromJson(String json) {
        return JsonUtil.parse(json, FetchScanTasksRequestParser::fromJson);
    }

    public static FetchScanTasksRequest fromJson(JsonNode json) {
        Preconditions.checkArgument((null != json ? 1 : 0) != 0, (Object)"Invalid fetchScanTasks request: null");
        String planTask = JsonUtil.getString(PLAN_TASK, json);
        return new FetchScanTasksRequest(planTask);
    }
}

