/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.extension.auth.opa;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import io.smallrye.config.ConfigMapping;
import io.smallrye.config.WithDefault;
import java.net.URI;
import java.nio.file.Path;
import java.time.Duration;
import java.util.Optional;
import org.apache.polaris.immutables.PolarisImmutable;

@ConfigMapping(prefix="polaris.authorization.opa")
@PolarisImmutable
public interface OpaAuthorizationConfig {
    public Optional<URI> policyUri();

    public AuthenticationConfig auth();

    public HttpConfig http();

    default public void validate() {
        Preconditions.checkArgument((boolean)this.policyUri().isPresent(), (Object)"polaris.authorization.opa.policy-uri must be configured");
        URI uri = this.policyUri().get();
        String scheme = uri.getScheme();
        Preconditions.checkArgument(("http".equalsIgnoreCase(scheme) || "https".equalsIgnoreCase(scheme) ? 1 : 0) != 0, (Object)("polaris.authorization.opa.policy-uri must use http or https scheme, but got: " + scheme));
        this.auth().validate();
    }

    @PolarisImmutable
    public static interface AuthenticationConfig {
        @WithDefault(value="none")
        public AuthenticationType type();

        public Optional<BearerTokenConfig> bearer();

        default public void validate() {
            switch (this.type().ordinal()) {
                case 1: {
                    Preconditions.checkArgument((boolean)this.bearer().isPresent(), (Object)"Bearer configuration is required when type is 'bearer'");
                    this.bearer().get().validate();
                    break;
                }
                case 0: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid authentication type: " + String.valueOf((Object)this.type()) + ". Supported types: 'bearer', 'none'");
                }
            }
        }
    }

    @PolarisImmutable
    public static interface BearerTokenConfig {
        public Optional<StaticTokenConfig> staticToken();

        public Optional<FileBasedConfig> fileBased();

        default public void validate() {
            Preconditions.checkArgument((boolean)(this.staticToken().isPresent() ^ this.fileBased().isPresent()), (Object)"Exactly one of 'static-token' or 'file-based' bearer token configuration must be specified");
            if (this.staticToken().isPresent()) {
                this.staticToken().get().validate();
            } else {
                this.fileBased().get().validate();
            }
        }

        @PolarisImmutable
        public static interface StaticTokenConfig {
            public String value();

            default public void validate() {
                Preconditions.checkArgument((!Strings.isNullOrEmpty((String)this.value()) ? 1 : 0) != 0, (Object)"Static bearer token value cannot be null or empty");
            }
        }

        @PolarisImmutable
        public static interface FileBasedConfig {
            public Path path();

            public Optional<Duration> refreshInterval();

            public Optional<Boolean> jwtExpirationRefresh();

            public Optional<Duration> jwtExpirationBuffer();

            default public void validate() {
                Preconditions.checkArgument((this.refreshInterval().isEmpty() || this.refreshInterval().get().isPositive() ? 1 : 0) != 0, (Object)"refreshInterval must be positive");
                Preconditions.checkArgument((this.jwtExpirationBuffer().isEmpty() || this.jwtExpirationBuffer().get().isPositive() ? 1 : 0) != 0, (Object)"jwtExpirationBuffer must be positive");
            }
        }
    }

    @PolarisImmutable
    public static interface HttpConfig {
        @WithDefault(value="PT2S")
        public Duration timeout();

        @WithDefault(value="true")
        public boolean verifySsl();

        public Optional<Path> trustStorePath();

        public Optional<String> trustStorePassword();
    }

    public static enum AuthenticationType {
        NONE("none"),
        BEARER("bearer");

        private final String value;

        private AuthenticationType(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }
}

