/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.service.task;

import java.util.List;
import java.util.Spliterators;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.stream.StreamSupport;
import org.apache.iceberg.ManifestFile;
import org.apache.iceberg.ManifestFiles;
import org.apache.iceberg.ManifestReader;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.io.FileIO;
import org.apache.polaris.core.context.CallContext;
import org.apache.polaris.core.entity.AsyncTaskType;
import org.apache.polaris.core.entity.TaskEntity;
import org.apache.polaris.service.task.FileCleanupTaskHandler;
import org.apache.polaris.service.task.TaskFileIOSupplier;
import org.apache.polaris.service.task.TaskUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManifestFileCleanupTaskHandler
extends FileCleanupTaskHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(ManifestFileCleanupTaskHandler.class);

    public ManifestFileCleanupTaskHandler(TaskFileIOSupplier fileIOSupplier, ExecutorService executorService) {
        super(fileIOSupplier, executorService);
    }

    @Override
    public boolean canHandleTask(TaskEntity task) {
        return task.getTaskType() == AsyncTaskType.MANIFEST_FILE_CLEANUP;
    }

    @Override
    public boolean handleTask(TaskEntity task, CallContext callContext) {
        ManifestCleanupTask cleanupTask = (ManifestCleanupTask)task.readData(ManifestCleanupTask.class);
        TableIdentifier tableId = cleanupTask.tableId();
        try (FileIO authorizedFileIO = this.fileIOSupplier.apply(task, tableId);){
            ManifestFile manifestFile = TaskUtils.decodeManifestFileData(cleanupTask.manifestFileData());
            boolean bl = this.cleanUpManifestFile(manifestFile, authorizedFileIO, tableId);
            return bl;
        }
    }

    private boolean cleanUpManifestFile(ManifestFile manifestFile, FileIO fileIO, TableIdentifier tableId) {
        if (!TaskUtils.exists(manifestFile.path(), fileIO)) {
            LOGGER.atWarn().addKeyValue("manifestFile", (Object)manifestFile.path()).addKeyValue("tableId", (Object)tableId).log("Manifest cleanup task scheduled, but manifest file doesn't exist");
            return true;
        }
        ManifestReader dataFiles = ManifestFiles.read((ManifestFile)manifestFile, (FileIO)fileIO);
        List<CompletableFuture> dataFileDeletes = StreamSupport.stream(Spliterators.spliteratorUnknownSize(dataFiles.iterator(), 1024), false).map(file -> this.tryDelete(tableId, fileIO, manifestFile.path(), file.location(), null, 1)).toList();
        LOGGER.debug("Scheduled {} data files to be deleted from manifest {}", (Object)dataFileDeletes.size(), (Object)manifestFile.path());
        try {
            ((CompletableFuture)CompletableFuture.allOf((CompletableFuture[])dataFileDeletes.toArray(CompletableFuture[]::new)).thenCompose(v -> {
                LOGGER.atInfo().addKeyValue("manifestFile", (Object)manifestFile.path()).log("All data files in manifest deleted - deleting manifest");
                return this.tryDelete(tableId, fileIO, manifestFile.path(), manifestFile.path(), null, 1);
            })).get();
            return true;
        }
        catch (InterruptedException e) {
            LOGGER.error("Interrupted exception deleting data files from manifest {}", (Object)manifestFile.path(), (Object)e);
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            LOGGER.error("Unable to delete data files from manifest {}", (Object)manifestFile.path(), (Object)e);
            return false;
        }
    }

    public record ManifestCleanupTask(TableIdentifier tableId, String manifestFileData) {
        static ManifestCleanupTask buildFrom(TableIdentifier tableId, ManifestFile manifestFile) {
            String encodedManifestFileData = TaskUtils.encodeManifestFile(manifestFile);
            return new ManifestCleanupTask(tableId, encodedManifestFileData);
        }
    }
}

