/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.service.catalog.iceberg;

import io.smallrye.common.annotation.Identifier;
import jakarta.enterprise.context.ApplicationScoped;
import java.util.Map;
import org.apache.iceberg.catalog.Catalog;
import org.apache.iceberg.catalog.SessionCatalog;
import org.apache.iceberg.rest.HTTPClient;
import org.apache.iceberg.rest.RESTCatalog;
import org.apache.polaris.core.catalog.ExternalCatalogFactory;
import org.apache.polaris.core.catalog.GenericTableCatalog;
import org.apache.polaris.core.connection.ConnectionConfigInfoDpo;
import org.apache.polaris.core.connection.iceberg.IcebergRestConnectionConfigInfoDpo;
import org.apache.polaris.core.credentials.PolarisCredentialManager;

@ApplicationScoped
@Identifier(value="iceberg_rest")
public class IcebergRESTExternalCatalogFactory
implements ExternalCatalogFactory {
    public Catalog createCatalog(ConnectionConfigInfoDpo connectionConfig, PolarisCredentialManager polarisCredentialManager) {
        if (!(connectionConfig instanceof IcebergRestConnectionConfigInfoDpo)) {
            throw new IllegalArgumentException("Expected IcebergRestConnectionConfigInfoDpo but got: " + connectionConfig.getClass().getSimpleName());
        }
        IcebergRestConnectionConfigInfoDpo icebergConfig = (IcebergRestConnectionConfigInfoDpo)connectionConfig;
        SessionCatalog.SessionContext context = SessionCatalog.SessionContext.createEmpty();
        RESTCatalog federatedCatalog = new RESTCatalog(context, config -> HTTPClient.builder((Map)config).uri((String)config.get("uri")).build());
        federatedCatalog.initialize(icebergConfig.getRemoteCatalogName(), connectionConfig.asIcebergCatalogProperties(polarisCredentialManager));
        return federatedCatalog;
    }

    public GenericTableCatalog createGenericCatalog(ConnectionConfigInfoDpo connectionConfig, PolarisCredentialManager polarisCredentialManager) {
        throw new UnsupportedOperationException("Generic table federation to this catalog is not supported.");
    }
}

