/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.service.admin;

import jakarta.annotation.Priority;
import jakarta.decorator.Decorator;
import jakarta.decorator.Delegate;
import jakarta.inject.Inject;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.SecurityContext;
import org.apache.polaris.core.admin.model.CreatePrincipalRoleRequest;
import org.apache.polaris.core.admin.model.GrantCatalogRoleRequest;
import org.apache.polaris.core.admin.model.PrincipalRole;
import org.apache.polaris.core.admin.model.UpdatePrincipalRoleRequest;
import org.apache.polaris.core.context.RealmContext;
import org.apache.polaris.service.admin.api.PolarisPrincipalRolesApiService;
import org.apache.polaris.service.events.PrincipalRolesServiceEvents;
import org.apache.polaris.service.events.listeners.PolarisEventListener;

@Decorator
@Priority(value=1000)
public class PolarisPrincipalRolesEventServiceDelegator
implements PolarisPrincipalRolesApiService {
    @Inject
    @Delegate
    PolarisPrincipalRolesApiService delegate;
    @Inject
    PolarisEventListener polarisEventListener;

    public Response createPrincipalRole(CreatePrincipalRoleRequest request, RealmContext realmContext, SecurityContext securityContext) {
        this.polarisEventListener.onBeforeCreatePrincipalRole(new PrincipalRolesServiceEvents.BeforeCreatePrincipalRoleEvent(request));
        Response resp = this.delegate.createPrincipalRole(request, realmContext, securityContext);
        this.polarisEventListener.onAfterCreatePrincipalRole(new PrincipalRolesServiceEvents.AfterCreatePrincipalRoleEvent((PrincipalRole)resp.getEntity()));
        return resp;
    }

    public Response deletePrincipalRole(String principalRoleName, RealmContext realmContext, SecurityContext securityContext) {
        this.polarisEventListener.onBeforeDeletePrincipalRole(new PrincipalRolesServiceEvents.BeforeDeletePrincipalRoleEvent(principalRoleName));
        Response resp = this.delegate.deletePrincipalRole(principalRoleName, realmContext, securityContext);
        this.polarisEventListener.onAfterDeletePrincipalRole(new PrincipalRolesServiceEvents.AfterDeletePrincipalRoleEvent(principalRoleName));
        return resp;
    }

    public Response getPrincipalRole(String principalRoleName, RealmContext realmContext, SecurityContext securityContext) {
        this.polarisEventListener.onBeforeGetPrincipalRole(new PrincipalRolesServiceEvents.BeforeGetPrincipalRoleEvent(principalRoleName));
        Response resp = this.delegate.getPrincipalRole(principalRoleName, realmContext, securityContext);
        this.polarisEventListener.onAfterGetPrincipalRole(new PrincipalRolesServiceEvents.AfterGetPrincipalRoleEvent((PrincipalRole)resp.getEntity()));
        return resp;
    }

    public Response updatePrincipalRole(String principalRoleName, UpdatePrincipalRoleRequest updateRequest, RealmContext realmContext, SecurityContext securityContext) {
        this.polarisEventListener.onBeforeUpdatePrincipalRole(new PrincipalRolesServiceEvents.BeforeUpdatePrincipalRoleEvent(principalRoleName, updateRequest));
        Response resp = this.delegate.updatePrincipalRole(principalRoleName, updateRequest, realmContext, securityContext);
        this.polarisEventListener.onAfterUpdatePrincipalRole(new PrincipalRolesServiceEvents.AfterUpdatePrincipalRoleEvent((PrincipalRole)resp.getEntity()));
        return resp;
    }

    public Response listPrincipalRoles(RealmContext realmContext, SecurityContext securityContext) {
        this.polarisEventListener.onBeforeListPrincipalRoles(new PrincipalRolesServiceEvents.BeforeListPrincipalRolesEvent());
        Response resp = this.delegate.listPrincipalRoles(realmContext, securityContext);
        this.polarisEventListener.onAfterListPrincipalRoles(new PrincipalRolesServiceEvents.AfterListPrincipalRolesEvent());
        return resp;
    }

    public Response assignCatalogRoleToPrincipalRole(String principalRoleName, String catalogName, GrantCatalogRoleRequest request, RealmContext realmContext, SecurityContext securityContext) {
        this.polarisEventListener.onBeforeAssignCatalogRoleToPrincipalRole(new PrincipalRolesServiceEvents.BeforeAssignCatalogRoleToPrincipalRoleEvent(principalRoleName, catalogName, request.getCatalogRole().getName()));
        Response resp = this.delegate.assignCatalogRoleToPrincipalRole(principalRoleName, catalogName, request, realmContext, securityContext);
        this.polarisEventListener.onAfterAssignCatalogRoleToPrincipalRole(new PrincipalRolesServiceEvents.AfterAssignCatalogRoleToPrincipalRoleEvent(principalRoleName, catalogName, request.getCatalogRole().getName()));
        return resp;
    }

    public Response revokeCatalogRoleFromPrincipalRole(String principalRoleName, String catalogName, String catalogRoleName, RealmContext realmContext, SecurityContext securityContext) {
        this.polarisEventListener.onBeforeRevokeCatalogRoleFromPrincipalRole(new PrincipalRolesServiceEvents.BeforeRevokeCatalogRoleFromPrincipalRoleEvent(principalRoleName, catalogName, catalogRoleName));
        Response resp = this.delegate.revokeCatalogRoleFromPrincipalRole(principalRoleName, catalogName, catalogRoleName, realmContext, securityContext);
        this.polarisEventListener.onAfterRevokeCatalogRoleFromPrincipalRole(new PrincipalRolesServiceEvents.AfterRevokeCatalogRoleFromPrincipalRoleEvent(principalRoleName, catalogName, catalogRoleName));
        return resp;
    }

    public Response listAssigneePrincipalsForPrincipalRole(String principalRoleName, RealmContext realmContext, SecurityContext securityContext) {
        this.polarisEventListener.onBeforeListAssigneePrincipalsForPrincipalRole(new PrincipalRolesServiceEvents.BeforeListAssigneePrincipalsForPrincipalRoleEvent(principalRoleName));
        Response resp = this.delegate.listAssigneePrincipalsForPrincipalRole(principalRoleName, realmContext, securityContext);
        this.polarisEventListener.onAfterListAssigneePrincipalsForPrincipalRole(new PrincipalRolesServiceEvents.AfterListAssigneePrincipalsForPrincipalRoleEvent(principalRoleName));
        return resp;
    }

    public Response listCatalogRolesForPrincipalRole(String principalRoleName, String catalogName, RealmContext realmContext, SecurityContext securityContext) {
        this.polarisEventListener.onBeforeListCatalogRolesForPrincipalRole(new PrincipalRolesServiceEvents.BeforeListCatalogRolesForPrincipalRoleEvent(principalRoleName, catalogName));
        Response resp = this.delegate.listCatalogRolesForPrincipalRole(principalRoleName, catalogName, realmContext, securityContext);
        this.polarisEventListener.onAfterListCatalogRolesForPrincipalRole(new PrincipalRolesServiceEvents.AfterListCatalogRolesForPrincipalRoleEvent(principalRoleName, catalogName));
        return resp;
    }
}

