/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.core.persistence.resolver;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.polaris.core.PolarisDiagnostics;
import org.apache.polaris.core.auth.PolarisPrincipal;
import org.apache.polaris.core.context.RealmContext;
import org.apache.polaris.core.entity.PolarisBaseEntity;
import org.apache.polaris.core.entity.PolarisEntityConstants;
import org.apache.polaris.core.entity.PolarisEntitySubType;
import org.apache.polaris.core.entity.PolarisEntityType;
import org.apache.polaris.core.persistence.PolarisResolvedPathWrapper;
import org.apache.polaris.core.persistence.ResolvedPolarisEntity;
import org.apache.polaris.core.persistence.resolver.PolarisResolutionManifestCatalogView;
import org.apache.polaris.core.persistence.resolver.Resolver;
import org.apache.polaris.core.persistence.resolver.ResolverFactory;
import org.apache.polaris.core.persistence.resolver.ResolverPath;
import org.apache.polaris.core.persistence.resolver.ResolverStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PolarisResolutionManifest
implements PolarisResolutionManifestCatalogView {
    private static final Logger LOGGER = LoggerFactory.getLogger(PolarisResolutionManifest.class);
    private final ResolverFactory resolverFactory;
    private final PolarisPrincipal principal;
    private final RealmContext realmContext;
    private final String catalogName;
    private final Resolver primaryResolver;
    private final PolarisDiagnostics diagnostics;
    private final Map<Object, Integer> pathLookup = new HashMap<Object, Integer>();
    private final List<ResolverPath> addedPaths = new ArrayList<ResolverPath>();
    private final Multimap<String, PolarisEntityType> addedTopLevelNames = HashMultimap.create();
    private final Map<Object, ResolverPath> passthroughPaths = new HashMap<Object, ResolverPath>();
    private int currentPathIndex = 0;
    private ResolverStatus primaryResolverStatus = null;

    private boolean isResolveAllSucceeded() {
        this.diagnostics.checkNotNull(this.primaryResolverStatus, "resolver_not_run_before_access", "resolveAll() must be called before reading resolution results", new Object[0]);
        return this.primaryResolverStatus.getStatus() == ResolverStatus.StatusEnum.SUCCESS;
    }

    public PolarisResolutionManifest(PolarisDiagnostics diagnostics, RealmContext realmContext, ResolverFactory resolverFactory, PolarisPrincipal principal, String catalogName) {
        this.realmContext = realmContext;
        this.resolverFactory = resolverFactory;
        this.catalogName = catalogName;
        this.diagnostics = diagnostics;
        this.diagnostics.checkNotNull(principal, "null_principal_for_resolution_manifest");
        this.principal = principal;
        this.primaryResolver = resolverFactory.createResolver(principal, catalogName);
        this.addTopLevelName(PolarisEntityConstants.getRootContainerName(), PolarisEntityType.ROOT, true);
    }

    public void addTopLevelName(String entityName, PolarisEntityType entityType, boolean isOptional) {
        this.addedTopLevelNames.put((Object)entityName, (Object)entityType);
        if (isOptional) {
            this.primaryResolver.addOptionalEntityByName(entityType, entityName);
        } else {
            this.primaryResolver.addEntityByName(entityType, entityName);
        }
    }

    public void addPath(ResolverPath path, Object key) {
        this.primaryResolver.addPath(path);
        this.pathLookup.put(key, this.currentPathIndex);
        this.addedPaths.add(path);
        ++this.currentPathIndex;
    }

    public void addPassthroughPath(ResolverPath path, Object key) {
        this.addPath(path, key);
        this.passthroughPaths.put(key, path);
    }

    public ResolverStatus resolveAll() {
        this.primaryResolverStatus = this.primaryResolver.resolveAll();
        this.diagnostics.check(this.primaryResolverStatus.getStatus() != ResolverStatus.StatusEnum.CALLER_PRINCIPAL_DOES_NOT_EXIST, "caller_principal_does_not_exist_at_resolution_time");
        return this.primaryResolverStatus;
    }

    public boolean getIsPassthroughFacade() {
        return this.primaryResolver.getIsPassthroughFacade();
    }

    @Override
    public PolarisResolvedPathWrapper getResolvedReferenceCatalogEntity() {
        return this.getResolvedReferenceCatalogEntity(false);
    }

    @Override
    public PolarisResolvedPathWrapper getResolvedPath(Object key) {
        return this.getResolvedPath(key, false);
    }

    @Override
    public PolarisResolvedPathWrapper getResolvedPath(Object key, PolarisEntityType entityType, PolarisEntitySubType subType) {
        return this.getResolvedPath(key, entityType, subType, false);
    }

    @Override
    public PolarisResolvedPathWrapper getPassthroughResolvedPath(Object key) {
        this.diagnostics.check(this.passthroughPaths.containsKey(key), "invalid_key_for_passthrough_resolved_path", "key={} passthroughPaths={}", key, this.passthroughPaths);
        ResolverPath requestedPath = this.passthroughPaths.get(key);
        Resolver passthroughResolver = this.resolverFactory.createResolver(this.principal, this.catalogName);
        passthroughResolver.addPath(requestedPath);
        ResolverStatus status = passthroughResolver.resolveAll();
        if (status.getStatus() != ResolverStatus.StatusEnum.SUCCESS) {
            LOGGER.debug("Returning null for key {} due to resolver status {}", key, (Object)status.getStatus());
            return null;
        }
        List<ResolvedPolarisEntity> resolvedPath = passthroughResolver.getResolvedPath();
        if (requestedPath.isOptional() && !this.getIsPassthroughFacade() && resolvedPath.size() != requestedPath.getEntityNames().size()) {
            LOGGER.debug("Returning null for key {} due to size mismatch from getPassthroughResolvedPath resolvedPath: {}, requestedPath.getEntityNames(): {}", new Object[]{key, resolvedPath, requestedPath.getEntityNames()});
            return null;
        }
        ArrayList<ResolvedPolarisEntity> resolvedEntities = new ArrayList<ResolvedPolarisEntity>();
        resolvedEntities.add(passthroughResolver.getResolvedReferenceCatalog());
        resolvedPath.forEach(resolvedEntity -> resolvedEntities.add((ResolvedPolarisEntity)resolvedEntity));
        LOGGER.debug("Returning resolvedEntities from getPassthroughResolvedPath: {}", resolvedEntities);
        return new PolarisResolvedPathWrapper(resolvedEntities);
    }

    @Override
    public PolarisResolvedPathWrapper getPassthroughResolvedPath(Object key, PolarisEntityType entityType, PolarisEntitySubType subType) {
        PolarisResolvedPathWrapper resolvedPath = this.getPassthroughResolvedPath(key);
        if (resolvedPath == null) {
            return null;
        }
        if (resolvedPath.getRawLeafEntity() != null && subType != PolarisEntitySubType.ANY_SUBTYPE && resolvedPath.getRawLeafEntity().getSubType() != subType) {
            return null;
        }
        return resolvedPath;
    }

    public Set<PolarisBaseEntity> getAllActivatedCatalogRoleAndPrincipalRoles() {
        HashSet<PolarisBaseEntity> activatedRoles = new HashSet<PolarisBaseEntity>();
        this.primaryResolver.getResolvedCallerPrincipalRoles().stream().map(ResolvedPolarisEntity::getEntity).forEach(activatedRoles::add);
        if (this.primaryResolver.getResolvedCatalogRoles() != null) {
            this.primaryResolver.getResolvedCatalogRoles().values().stream().map(ResolvedPolarisEntity::getEntity).forEach(activatedRoles::add);
        }
        return activatedRoles;
    }

    public Set<PolarisBaseEntity> getAllActivatedPrincipalRoleEntities() {
        HashSet<PolarisBaseEntity> activatedEntities = new HashSet<PolarisBaseEntity>();
        this.primaryResolver.getResolvedCallerPrincipalRoles().stream().map(ResolvedPolarisEntity::getEntity).forEach(activatedEntities::add);
        return activatedEntities;
    }

    @Nullable
    private ResolvedPolarisEntity getResolvedRootContainerEntity() {
        if (!this.isResolveAllSucceeded()) {
            return null;
        }
        ResolvedPolarisEntity resolvedEntity = this.primaryResolver.getResolvedEntity(PolarisEntityType.ROOT, PolarisEntityConstants.getRootContainerName());
        if (resolvedEntity == null) {
            LOGGER.warn("Failed to find rootContainer for realm: {} and catalog: {}", (Object)this.realmContext.getRealmIdentifier(), (Object)this.catalogName);
        }
        return resolvedEntity;
    }

    public PolarisResolvedPathWrapper getResolvedRootContainerEntityAsPath() {
        return new PolarisResolvedPathWrapper(List.of(this.getResolvedRootContainerEntity()));
    }

    public PolarisResolvedPathWrapper getResolvedReferenceCatalogEntity(boolean prependRootContainer) {
        this.diagnostics.checkNotNull(this.catalogName, "null_catalog_name_for_resolved_reference_catalog");
        ResolvedPolarisEntity resolvedReferenceCatalog = this.primaryResolver.getResolvedReferenceCatalog();
        if (resolvedReferenceCatalog == null) {
            return null;
        }
        if (prependRootContainer) {
            return new PolarisResolvedPathWrapper(List.of(this.getResolvedRootContainerEntity(), resolvedReferenceCatalog));
        }
        return new PolarisResolvedPathWrapper(List.of(resolvedReferenceCatalog));
    }

    public PolarisEntitySubType getLeafSubType(Object key) {
        this.diagnostics.check(this.pathLookup.containsKey(key), "never_registered_key_for_resolved_path", "key={} pathLookup={}", key, this.pathLookup);
        int index = this.pathLookup.get(key);
        List<ResolvedPolarisEntity> resolved = this.primaryResolver.getResolvedPaths().get(index);
        if (resolved.isEmpty()) {
            return PolarisEntitySubType.NULL_SUBTYPE;
        }
        return resolved.get(resolved.size() - 1).getEntity().getSubType();
    }

    public PolarisResolvedPathWrapper getResolvedPath(Object key, boolean prependRootContainer) {
        this.diagnostics.check(this.pathLookup.containsKey(key), "never_registered_key_for_resolved_path", "key={} pathLookup={}", key, this.pathLookup);
        if (!this.isResolveAllSucceeded()) {
            return null;
        }
        int index = this.pathLookup.get(key);
        ResolverPath requestedPath = this.addedPaths.get(index);
        List<ResolvedPolarisEntity> resolvedPath = this.primaryResolver.getResolvedPaths().get(index);
        if (requestedPath.isOptional() && !this.getIsPassthroughFacade() && resolvedPath.size() != requestedPath.getEntityNames().size()) {
            return null;
        }
        ArrayList<ResolvedPolarisEntity> resolvedEntities = new ArrayList<ResolvedPolarisEntity>();
        if (prependRootContainer) {
            resolvedEntities.add(this.getResolvedRootContainerEntity());
        }
        resolvedEntities.add(this.primaryResolver.getResolvedReferenceCatalog());
        resolvedPath.forEach(resolvedEntity -> resolvedEntities.add((ResolvedPolarisEntity)resolvedEntity));
        return new PolarisResolvedPathWrapper(resolvedEntities);
    }

    public PolarisResolvedPathWrapper getResolvedPath(Object key, PolarisEntityType entityType, PolarisEntitySubType subType, boolean prependRootContainer) {
        PolarisResolvedPathWrapper resolvedPath = this.getResolvedPath(key, prependRootContainer);
        if (resolvedPath == null) {
            return null;
        }
        if (!this.getIsPassthroughFacade() && resolvedPath.getRawLeafEntity() != null && subType != PolarisEntitySubType.ANY_SUBTYPE && resolvedPath.getRawLeafEntity().getSubType() != subType) {
            return null;
        }
        return resolvedPath;
    }

    public PolarisResolvedPathWrapper getResolvedTopLevelEntity(String entityName, PolarisEntityType entityType) {
        this.diagnostics.check(this.addedTopLevelNames.containsEntry((Object)entityName, (Object)entityType), "never_registered_top_level_name_and_type_for_resolved_entity", "entityName={} entityType={} addedTopLevelNames={}", new Object[]{entityName, entityType, this.addedTopLevelNames});
        if (!this.isResolveAllSucceeded()) {
            return null;
        }
        ResolvedPolarisEntity resolvedEntity = this.primaryResolver.getResolvedEntity(entityType, entityName);
        if (resolvedEntity == null) {
            return null;
        }
        ResolvedPolarisEntity resolvedRootContainerEntity = this.getResolvedRootContainerEntity();
        return resolvedRootContainerEntity == null ? new PolarisResolvedPathWrapper(List.of(resolvedEntity)) : new PolarisResolvedPathWrapper(List.of(resolvedRootContainerEntity, resolvedEntity));
    }
}

