/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.core.connection;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.iceberg.rest.auth.OAuth2Util;
import org.apache.polaris.core.admin.model.AuthenticationParameters;
import org.apache.polaris.core.admin.model.OAuthClientCredentialsParameters;
import org.apache.polaris.core.connection.AuthenticationParametersDpo;
import org.apache.polaris.core.connection.AuthenticationType;
import org.apache.polaris.core.credentials.PolarisCredentialManager;
import org.apache.polaris.core.secrets.SecretReference;

public class OAuthClientCredentialsParametersDpo
extends AuthenticationParametersDpo {
    private static final Joiner COLON_JOINER = Joiner.on((String)":");
    @JsonProperty(value="tokenUri")
    private final String tokenUri;
    @JsonProperty(value="clientId")
    private final String clientId;
    @JsonProperty(value="clientSecretReference")
    private final SecretReference clientSecretReference;
    @JsonProperty(value="scopes")
    private final List<String> scopes;

    public OAuthClientCredentialsParametersDpo(@JsonProperty(value="tokenUri", required=false) @Nullable String tokenUri, @JsonProperty(value="clientId", required=true) @Nonnull String clientId, @JsonProperty(value="clientSecretReference", required=true) @Nonnull SecretReference clientSecretReference, @JsonProperty(value="scopes", required=false) @Nullable List<String> scopes) {
        super(AuthenticationType.OAUTH.getCode());
        this.tokenUri = tokenUri;
        this.clientId = clientId;
        this.clientSecretReference = clientSecretReference;
        this.scopes = scopes;
        this.validateTokenUri(tokenUri);
    }

    @Nullable
    public String getTokenUri() {
        return this.tokenUri;
    }

    @Nonnull
    public String getClientId() {
        return this.clientId;
    }

    @Nonnull
    public SecretReference getClientSecretReference() {
        return this.clientSecretReference;
    }

    @Nullable
    public List<String> getScopes() {
        return this.scopes;
    }

    @JsonIgnore
    @Nonnull
    public String getScopesAsString() {
        return OAuth2Util.toScope((Iterable)Objects.requireNonNullElse(this.scopes, List.of("catalog")));
    }

    @Override
    @Nonnull
    public Map<String, String> asIcebergCatalogProperties(PolarisCredentialManager credentialManager) {
        HashMap<String, String> properties = new HashMap<String, String>();
        if (this.getTokenUri() != null) {
            properties.put("oauth2-server-uri", this.getTokenUri());
        }
        properties.put("scope", this.getScopesAsString());
        return properties;
    }

    @Override
    @Nonnull
    public AuthenticationParameters asAuthenticationParametersModel() {
        return OAuthClientCredentialsParameters.builder().setAuthenticationType(AuthenticationParameters.AuthenticationTypeEnum.OAUTH).setTokenUri(this.getTokenUri()).setClientId(this.getClientId()).setScopes(this.getScopes()).build();
    }

    protected void validateTokenUri(String tokenUri) {
        if (tokenUri == null) {
            return;
        }
        try {
            URI uri = URI.create(tokenUri);
            URL uRL = uri.toURL();
        }
        catch (IllegalArgumentException | MalformedURLException e) {
            throw new IllegalArgumentException("Invalid token URI: " + tokenUri, e);
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("authenticationTypeCode", this.getAuthenticationTypeCode()).add("tokenUri", (Object)this.getTokenUri()).add("clientId", (Object)this.getClientId()).add("clientSecretReference", (Object)this.getClientSecretReference()).add("scopes", (Object)this.getScopesAsString()).toString();
    }
}

