/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.xdbm.search.evaluator;

import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.filter.ScopeNode;
import org.apache.directory.api.ldap.model.message.SearchScope;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.server.core.api.partition.Partition;
import org.apache.directory.server.core.api.partition.PartitionTxn;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.server.xdbm.IndexEntry;
import org.apache.directory.server.xdbm.ParentIdAndRdn;
import org.apache.directory.server.xdbm.Store;
import org.apache.directory.server.xdbm.search.Evaluator;

public class SubtreeScopeEvaluator
implements Evaluator<ScopeNode> {
    private final ScopeNode node;
    private final String baseId;
    private final boolean baseIsContextEntry;
    private final boolean dereferencing;
    private final Store db;

    public SubtreeScopeEvaluator(PartitionTxn partitionTxn, Store db, ScopeNode node) throws LdapException {
        this.db = db;
        this.node = node;
        if (node.getScope() != SearchScope.SUBTREE) {
            throw new IllegalStateException(I18n.err((I18n)I18n.ERR_727, (Object[])new Object[0]));
        }
        this.baseId = node.getBaseId();
        this.baseIsContextEntry = db.getSuffixId(partitionTxn) == this.baseId;
        this.dereferencing = node.getDerefAliases().isDerefInSearching() || node.getDerefAliases().isDerefAlways();
    }

    private boolean isDescendant(PartitionTxn partitionTxn, String candidateId) throws LdapException {
        String tmp = candidateId;
        do {
            ParentIdAndRdn parentIdAndRdn;
            if ((parentIdAndRdn = this.db.getRdnIndex().reverseLookup(partitionTxn, tmp)) == null) {
                return false;
            }
            tmp = parentIdAndRdn.getParentId();
            if (!tmp.equals(Partition.ROOT_ID)) continue;
            return false;
        } while (!tmp.equals(this.baseId));
        return true;
    }

    @Override
    public boolean evaluate(PartitionTxn partitionTxn, IndexEntry<?, String> indexEntry) throws LdapException {
        Dn dn;
        boolean isDescendant;
        String id = indexEntry.getId();
        Entry entry = indexEntry.getEntry();
        if (null == entry) {
            entry = this.db.fetch(partitionTxn, indexEntry.getId());
            if (null == entry) {
                return false;
            }
            indexEntry.setEntry(entry);
        }
        boolean bl = isDescendant = this.baseIsContextEntry || this.baseId.equals(id) || entry.getDn().isDescendantOf(this.node.getBaseDn());
        if (!this.isDereferencing()) {
            return isDescendant;
        }
        if (this.db.getAliasCache() != null ? (dn = (Dn)this.db.getAliasCache().getIfPresent((Object)id)) != null : null != this.db.getAliasIndex().reverseLookup(partitionTxn, id)) {
            return false;
        }
        if (isDescendant) {
            return true;
        }
        return this.db.getSubAliasIndex().forward(partitionTxn, this.baseId, id);
    }

    @Override
    public boolean evaluate(Entry candidate) throws LdapException {
        throw new UnsupportedOperationException(I18n.err((I18n)I18n.ERR_721, (Object[])new Object[0]));
    }

    @Override
    public ScopeNode getExpression() {
        return this.node;
    }

    public String getBaseId() {
        return this.baseId;
    }

    public boolean isDereferencing() {
        return this.dereferencing;
    }

    @Override
    public String toString(String tabs) {
        StringBuilder sb = new StringBuilder();
        sb.append(tabs).append("SubstreeScopeEvaluator : ").append(this.node).append('\n');
        return sb.toString();
    }

    public String toString() {
        return this.toString("");
    }
}

