/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.xdbm.search.cursor;

import java.io.IOException;
import org.apache.directory.api.ldap.model.constants.Loggers;
import org.apache.directory.api.ldap.model.cursor.Cursor;
import org.apache.directory.api.ldap.model.cursor.CursorException;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.server.core.api.partition.PartitionTxn;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.server.xdbm.AbstractIndexCursor;
import org.apache.directory.server.xdbm.IndexEntry;
import org.apache.directory.server.xdbm.ParentIdAndRdn;
import org.apache.directory.server.xdbm.Store;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChildrenCursor
extends AbstractIndexCursor<String> {
    private static final Logger LOG_CURSOR = LoggerFactory.getLogger((String)Loggers.CURSOR_LOG.getName());
    private static final boolean IS_DEBUG = LOG_CURSOR.isDebugEnabled();
    private static final String UNSUPPORTED_MSG = I18n.err((I18n)I18n.ERR_719, (Object[])new Object[0]);
    private final Cursor<IndexEntry<ParentIdAndRdn, String>> cursor;
    private String parentId;
    private IndexEntry<String, String> prefetched;

    public ChildrenCursor(PartitionTxn partitionTxn, Store db, String parentId, Cursor<IndexEntry<ParentIdAndRdn, String>> cursor) {
        this.parentId = parentId;
        this.cursor = cursor;
        this.partitionTxn = partitionTxn;
        if (IS_DEBUG) {
            LOG_CURSOR.debug("Creating ChildrenCursor {}", (Object)this);
        }
    }

    @Override
    protected String getUnsupportedMessage() {
        return UNSUPPORTED_MSG;
    }

    public void beforeFirst() throws LdapException, CursorException {
        this.checkNotClosed();
        this.setAvailable(false);
    }

    public void afterLast() throws LdapException, CursorException {
        throw new UnsupportedOperationException(this.getUnsupportedMessage());
    }

    public boolean first() throws LdapException, CursorException {
        this.beforeFirst();
        return this.next();
    }

    public boolean last() throws LdapException, CursorException {
        throw new UnsupportedOperationException(this.getUnsupportedMessage());
    }

    @Override
    public boolean previous() throws LdapException, CursorException {
        IndexEntry entry;
        this.checkNotClosed();
        boolean hasPrevious = this.cursor.previous();
        if (hasPrevious && ((ParentIdAndRdn)(entry = (IndexEntry)this.cursor.get()).getTuple().getKey()).getParentId().equals(this.parentId)) {
            this.prefetched = entry;
            return true;
        }
        return false;
    }

    @Override
    public boolean next() throws LdapException, CursorException {
        this.checkNotClosed();
        boolean hasNext = this.cursor.next();
        if (hasNext) {
            IndexEntry cursorEntry = (IndexEntry)this.cursor.get();
            IndexEntry<String, String> entry = new IndexEntry<String, String>();
            entry.setId((String)cursorEntry.getId());
            entry.setKey(((ParentIdAndRdn)cursorEntry.getTuple().getKey()).getParentId());
            if (((String)entry.getKey()).equals(this.parentId)) {
                this.prefetched = entry;
                return true;
            }
        }
        return false;
    }

    public IndexEntry<String, String> get() throws CursorException {
        this.checkNotClosed();
        return this.prefetched;
    }

    public void close() throws IOException {
        if (IS_DEBUG) {
            LOG_CURSOR.debug("Closing ChildrenCursor {}", (Object)this);
        }
        this.cursor.close();
        super.close();
    }

    public void close(Exception cause) throws IOException {
        if (IS_DEBUG) {
            LOG_CURSOR.debug("Closing ChildrenCursor {}", (Object)this);
        }
        this.cursor.close(cause);
        super.close(cause);
    }

    public String toString(String tabs) {
        StringBuilder sb = new StringBuilder();
        sb.append(tabs).append("ChildrenCursor (");
        if (this.available()) {
            sb.append("available)");
        } else {
            sb.append("absent)");
        }
        sb.append("#parent<").append(this.parentId).append("> :\n");
        sb.append(this.cursor.toString(tabs + "  "));
        return sb.toString();
    }

    public String toString() {
        return this.toString("");
    }
}

