/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.net;

import java.io.IOException;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivilegedExceptionAction;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import javax.net.SocketFactory;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import org.apache.derby.client.net.NaiveTrustManager;

class OpenSocketAction
implements PrivilegedExceptionAction<Socket> {
    private String server_;
    private int port_;
    private int clientSSLMode_;

    OpenSocketAction(String string, int n, int n2) {
        this.server_ = string;
        this.port_ = n;
        this.clientSSLMode_ = n2;
    }

    @Override
    public Socket run() throws UnknownHostException, IOException, NoSuchAlgorithmException, KeyManagementException, NoSuchProviderException, KeyStoreException, UnrecoverableKeyException, CertificateException {
        SocketFactory socketFactory;
        switch (this.clientSSLMode_) {
            case 1: {
                socketFactory = NaiveTrustManager.getSocketFactory();
                break;
            }
            case 2: {
                socketFactory = SSLSocketFactory.getDefault();
                break;
            }
            case 0: {
                socketFactory = SocketFactory.getDefault();
                break;
            }
            default: {
                socketFactory = SocketFactory.getDefault();
            }
        }
        if (this.clientSSLMode_ == 1 || this.clientSSLMode_ == 2) {
            SSLSocket sSLSocket = (SSLSocket)socketFactory.createSocket(this.server_, this.port_);
            String[] stringArray = sSLSocket.getEnabledProtocols();
            String[] stringArray2 = new String[stringArray.length];
            int n = 0;
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].toUpperCase().contains("SSLV3") || stringArray[i].toUpperCase().contains("SSLV2HELLO")) continue;
                stringArray2[n] = stringArray[i];
                ++n;
            }
            if (n < stringArray.length) {
                String[] stringArray3 = null;
                stringArray3 = new String[n];
                System.arraycopy(stringArray2, 0, stringArray3, 0, n);
                sSLSocket.setEnabledProtocols(stringArray3);
            }
            return sSLSocket;
        }
        return socketFactory.createSocket(this.server_, this.port_);
    }
}

