/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.oauth.client;

import java.util.ArrayList;
import java.util.List;
import org.pac4j.core.client.IndirectClient;
import org.pac4j.oauth.client.OAuth20Client;
import org.pac4j.oauth.profile.qq.QQProfileCreator;
import org.pac4j.oauth.profile.qq.QQProfileDefinition;
import org.pac4j.scribe.builder.api.QQApi20;

public class QQClient
extends OAuth20Client {
    protected List<QQScope> scopes;

    public QQClient() {
    }

    public QQClient(String key, String secret) {
        this.setKey(key);
        this.setSecret(secret);
    }

    @Override
    protected void clientInit() {
        this.configuration.setApi(new QQApi20());
        this.configuration.setScope(this.getOAuthScope());
        this.configuration.setProfileDefinition(new QQProfileDefinition());
        this.configuration.setWithState(true);
        this.defaultProfileCreator(new QQProfileCreator(this.configuration, (IndirectClient)this));
        super.clientInit();
    }

    private String getOAuthScope() {
        StringBuilder builder = null;
        if (this.scopes != null) {
            for (QQScope value : this.scopes) {
                if (builder == null) {
                    builder = new StringBuilder();
                } else {
                    builder.append(",");
                }
                builder.append(value.toString().toLowerCase());
            }
        } else {
            builder = new StringBuilder();
            builder.append(QQScope.GET_USER_INFO.toString().toLowerCase());
        }
        return builder == null ? null : builder.toString();
    }

    public List<QQScope> getScopes() {
        return this.scopes;
    }

    public void setScopes(List<QQScope> scopes) {
        this.scopes = scopes;
    }

    public void addScope(QQScope scopes) {
        if (this.scopes == null) {
            this.scopes = new ArrayList<QQScope>();
        }
        this.scopes.add(scopes);
    }

    public static enum QQScope {
        GET_USER_INFO,
        GET_VIP_INFO,
        GET_VIP_RICH_INFO,
        LIST_ALBUM,
        UPLOAD_PIC,
        ADD_ALBUM,
        LIST_PHOTO,
        GET_TENPAY_ADDR;

    }
}

