/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.group.share;

import java.util.List;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.server.group.share.PartitionAllData;
import org.apache.kafka.server.group.share.PartitionData;
import org.apache.kafka.server.group.share.PartitionErrorData;
import org.apache.kafka.server.group.share.PartitionIdData;
import org.apache.kafka.server.group.share.PartitionIdLeaderEpochData;
import org.apache.kafka.server.group.share.PartitionStateBatchData;
import org.apache.kafka.server.group.share.PartitionStateData;
import org.apache.kafka.server.group.share.PartitionStateErrorData;
import org.apache.kafka.server.group.share.PersisterStateBatch;

public class PartitionFactory {
    public static final int DEFAULT_STATE_EPOCH = 0;
    public static final int DEFAULT_START_OFFSET = 0;
    public static final short DEFAULT_ERROR_CODE = Errors.NONE.code();
    public static final int DEFAULT_LEADER_EPOCH = 0;
    public static final String DEFAULT_ERR_MESSAGE = Errors.NONE.message();

    public static PartitionIdData newPartitionIdData(int partition) {
        return new PartitionData(partition, 0, 0L, DEFAULT_ERROR_CODE, DEFAULT_ERR_MESSAGE, 0, null);
    }

    public static PartitionIdLeaderEpochData newPartitionIdLeaderEpochData(int partition, int leaderEpoch) {
        return new PartitionData(partition, 0, 0L, DEFAULT_ERROR_CODE, DEFAULT_ERR_MESSAGE, leaderEpoch, null);
    }

    public static PartitionStateData newPartitionStateData(int partition, int stateEpoch, long startOffset) {
        return new PartitionData(partition, stateEpoch, startOffset, DEFAULT_ERROR_CODE, DEFAULT_ERR_MESSAGE, 0, null);
    }

    public static PartitionErrorData newPartitionErrorData(int partition, short errorCode, String errorMessage) {
        return new PartitionData(partition, 0, 0L, errorCode, errorMessage, 0, null);
    }

    public static PartitionStateErrorData newPartitionStateErrorData(int partition, int stateEpoch, long startOffset, short errorCode, String errorMessage) {
        return new PartitionData(partition, stateEpoch, startOffset, errorCode, errorMessage, 0, null);
    }

    public static PartitionStateBatchData newPartitionStateBatchData(int partition, int stateEpoch, long startOffset, int leaderEpoch, List<PersisterStateBatch> stateBatches) {
        return new PartitionData(partition, stateEpoch, startOffset, DEFAULT_ERROR_CODE, DEFAULT_ERR_MESSAGE, leaderEpoch, stateBatches);
    }

    public static PartitionAllData newPartitionAllData(int partition, int stateEpoch, long startOffset, short errorCode, String errorMessage, List<PersisterStateBatch> stateBatches) {
        return new PartitionData(partition, stateEpoch, startOffset, errorCode, errorMessage, 0, stateBatches);
    }
}

