/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fluss.fs.s3.token;

import java.util.Map;
import org.apache.fluss.fs.s3.token.DynamicTemporaryAWSCredentialsProvider;
import org.apache.fluss.fs.token.Credentials;
import org.apache.fluss.fs.token.CredentialsJsonSerde;
import org.apache.fluss.fs.token.ObtainedSecurityToken;
import org.apache.fluss.fs.token.SecurityTokenReceiver;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.s3a.auth.NoAwsCredentialsException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class S3DelegationTokenReceiver
implements SecurityTokenReceiver {
    public static final String PROVIDER_CONFIG_NAME = "fs.s3a.aws.credentials.provider";
    private static final Logger LOG = LoggerFactory.getLogger(S3DelegationTokenReceiver.class);
    static volatile Credentials credentials;
    static volatile Map<String, String> additionInfos;

    public static void updateHadoopConfig(Configuration hadoopConfig) {
        LOG.info("Updating Hadoop configuration");
        Object providers = hadoopConfig.get(PROVIDER_CONFIG_NAME, "");
        if (!((String)providers).contains(DynamicTemporaryAWSCredentialsProvider.NAME)) {
            if (((String)providers).isEmpty()) {
                LOG.debug("Setting provider");
                providers = DynamicTemporaryAWSCredentialsProvider.NAME;
            } else {
                providers = DynamicTemporaryAWSCredentialsProvider.NAME + "," + (String)providers;
                LOG.debug("Prepending provider, new providers value: {}", providers);
            }
            hadoopConfig.set(PROVIDER_CONFIG_NAME, (String)providers);
        } else {
            LOG.debug("Provider already exists");
        }
        if (additionInfos == null) {
            throw new NoAwsCredentialsException("Dynamic session credentials for Fluss");
        }
        for (Map.Entry<String, String> entry : additionInfos.entrySet()) {
            hadoopConfig.set(entry.getKey(), entry.getValue());
        }
        LOG.info("Updated Hadoop configuration successfully");
    }

    public String scheme() {
        return "s3";
    }

    public void onNewTokensObtained(ObtainedSecurityToken token) {
        LOG.info("Updating session credentials");
        byte[] tokenBytes = token.getToken();
        credentials = CredentialsJsonSerde.fromJson((byte[])tokenBytes);
        additionInfos = token.getAdditionInfos();
        LOG.info("Session credentials updated successfully with access key: {}.", (Object)credentials.getAccessKeyId());
    }

    public static Credentials getCredentials() {
        return credentials;
    }
}

