/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fluss.fs.oss;

import com.aliyun.oss.OSSClient;
import com.aliyun.oss.common.comm.SignVersion;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.URI;
import org.apache.fluss.annotation.VisibleForTesting;
import org.apache.fluss.config.ConfigBuilder;
import org.apache.fluss.config.Configuration;
import org.apache.fluss.exception.FlussRuntimeException;
import org.apache.fluss.fs.FileSystem;
import org.apache.fluss.fs.FileSystemPlugin;
import org.apache.fluss.fs.oss.OSSFileSystem;
import org.apache.fluss.fs.oss.token.OSSSecurityTokenReceiver;
import org.apache.hadoop.fs.aliyun.oss.AliyunOSSFileSystem;
import org.apache.hadoop.fs.aliyun.oss.AliyunOSSFileSystemStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OSSFileSystemPlugin
implements FileSystemPlugin {
    private static final Logger LOG = LoggerFactory.getLogger(OSSFileSystemPlugin.class);
    public static final String SCHEME = "oss";
    private static final String[] FLUSS_CONFIG_PREFIXES = new String[]{"fs.oss."};
    public static final String REGION_KEY = "fs.oss.region";

    public String getScheme() {
        return SCHEME;
    }

    public FileSystem create(URI fsUri, Configuration flussConfig) throws IOException {
        URI defaultUri;
        org.apache.hadoop.conf.Configuration hadoopConfig = this.getHadoopConfiguration(flussConfig);
        if (hadoopConfig.get("fs.oss.accessKeyId") == null) {
            String credentialsProvider = hadoopConfig.get("fs.oss.credentials.provider");
            if (credentialsProvider != null) {
                LOG.info("{} is not set, but {} is set, using credential provider {}.", new Object[]{"fs.oss.accessKeyId", "fs.oss.credentials.provider", credentialsProvider});
            } else {
                this.setDefaultCredentialProvider(flussConfig, hadoopConfig);
            }
        } else {
            LOG.info("{} is set, using provided access key id and secret.", (Object)"fs.oss.accessKeyId");
        }
        String scheme = fsUri.getScheme();
        String authority = fsUri.getAuthority();
        if (scheme == null && authority == null) {
            fsUri = org.apache.hadoop.fs.FileSystem.getDefaultUri(hadoopConfig);
        } else if (scheme != null && authority == null && scheme.equals((defaultUri = org.apache.hadoop.fs.FileSystem.getDefaultUri(hadoopConfig)).getScheme()) && defaultUri.getAuthority() != null) {
            fsUri = defaultUri;
        }
        org.apache.hadoop.fs.FileSystem fileSystem = this.initFileSystem(fsUri, hadoopConfig);
        return new OSSFileSystem(fileSystem, this.getScheme(), hadoopConfig);
    }

    protected org.apache.hadoop.fs.FileSystem initFileSystem(URI fsUri, org.apache.hadoop.conf.Configuration hadoopConfig) throws IOException {
        AliyunOSSFileSystem fileSystem = new AliyunOSSFileSystem();
        fileSystem.initialize(fsUri, hadoopConfig);
        this.setSignatureVersion4(fileSystem, hadoopConfig);
        return fileSystem;
    }

    protected void setDefaultCredentialProvider(Configuration flussConfig, org.apache.hadoop.conf.Configuration hadoopConfig) {
        OSSSecurityTokenReceiver.updateHadoopConfig(hadoopConfig);
    }

    @VisibleForTesting
    org.apache.hadoop.conf.Configuration getHadoopConfiguration(Configuration flussConfig) {
        org.apache.hadoop.conf.Configuration conf = new org.apache.hadoop.conf.Configuration();
        if (flussConfig == null) {
            return conf;
        }
        for (String key : flussConfig.keySet()) {
            for (String prefix : FLUSS_CONFIG_PREFIXES) {
                if (!key.startsWith(prefix)) continue;
                String value = flussConfig.getString(ConfigBuilder.key((String)key).stringType().noDefaultValue(), null);
                conf.set(key, value);
                LOG.debug("Adding Fluss config entry for {} as {} to Hadoop config", (Object)key, (Object)conf.get(key));
            }
        }
        return conf;
    }

    private void setSignatureVersion4(AliyunOSSFileSystem aliyunOSSFileSystem, org.apache.hadoop.conf.Configuration hadoopConfig) {
        AliyunOSSFileSystemStore aliyunOSSFileSystemStore = aliyunOSSFileSystem.getStore();
        try {
            Field ossClientField = aliyunOSSFileSystemStore.getClass().getDeclaredField("ossClient");
            ossClientField.setAccessible(true);
            OSSClient ossClient = (OSSClient)ossClientField.get(aliyunOSSFileSystemStore);
            ossClient.switchSignatureVersion(SignVersion.V4);
            String region = hadoopConfig.get(REGION_KEY);
            if (region == null) {
                throw new IllegalArgumentException(String.format("Region key %s must be set for oss file system.", REGION_KEY));
            }
            ossClient.setRegion(region);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new FlussRuntimeException("Fail to set signature version 4 for Oss filesystem.", (Throwable)e);
        }
    }
}

