/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.apache.paimon.casting.CastFieldGetter;
import org.apache.paimon.format.FileFormatDiscover;
import org.apache.paimon.format.FormatReaderFactory;
import org.apache.paimon.partition.PartitionUtils;
import org.apache.paimon.predicate.Predicate;
import org.apache.paimon.predicate.PredicateBuilder;
import org.apache.paimon.schema.IndexCastMapping;
import org.apache.paimon.schema.SchemaEvolutionUtil;
import org.apache.paimon.schema.TableSchema;
import org.apache.paimon.table.SpecialFields;
import org.apache.paimon.types.ArrayType;
import org.apache.paimon.types.DataField;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.MapType;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.Pair;

public class FormatReaderMapping {
    @Nullable
    private final int[] indexMapping;
    @Nullable
    private final CastFieldGetter[] castMapping;
    @Nullable
    private final Pair<int[], RowType> partitionPair;
    private final FormatReaderFactory readerFactory;
    private final TableSchema dataSchema;
    private final List<Predicate> dataFilters;

    public FormatReaderMapping(@Nullable int[] indexMapping, @Nullable CastFieldGetter[] castMapping, @Nullable int[] trimmedKeyMapping, @Nullable Pair<int[], RowType> partitionPair, FormatReaderFactory readerFactory, TableSchema dataSchema, List<Predicate> dataFilters) {
        this.indexMapping = this.combine(indexMapping, trimmedKeyMapping);
        this.castMapping = castMapping;
        this.readerFactory = readerFactory;
        this.partitionPair = partitionPair;
        this.dataSchema = dataSchema;
        this.dataFilters = dataFilters;
    }

    private int[] combine(@Nullable int[] indexMapping, @Nullable int[] trimmedKeyMapping) {
        if (indexMapping == null) {
            return trimmedKeyMapping;
        }
        if (trimmedKeyMapping == null) {
            return indexMapping;
        }
        int[] combined = new int[indexMapping.length];
        for (int i = 0; i < indexMapping.length; ++i) {
            combined[i] = indexMapping[i] < 0 ? indexMapping[i] : trimmedKeyMapping[indexMapping[i]];
        }
        return combined;
    }

    @Nullable
    public int[] getIndexMapping() {
        return this.indexMapping;
    }

    @Nullable
    public CastFieldGetter[] getCastMapping() {
        return this.castMapping;
    }

    @Nullable
    public Pair<int[], RowType> getPartitionPair() {
        return this.partitionPair;
    }

    public FormatReaderFactory getReaderFactory() {
        return this.readerFactory;
    }

    public TableSchema getDataSchema() {
        return this.dataSchema;
    }

    public List<Predicate> getDataFilters() {
        return this.dataFilters;
    }

    public static class Builder {
        private final FileFormatDiscover formatDiscover;
        private final List<DataField> readTableFields;
        private final Function<TableSchema, List<DataField>> fieldsExtractor;
        @Nullable
        private final List<Predicate> filters;

        public Builder(FileFormatDiscover formatDiscover, List<DataField> readTableFields, Function<TableSchema, List<DataField>> fieldsExtractor, @Nullable List<Predicate> filters) {
            this.formatDiscover = formatDiscover;
            this.readTableFields = readTableFields;
            this.fieldsExtractor = fieldsExtractor;
            this.filters = filters;
        }

        public FormatReaderMapping build(String formatIdentifier, TableSchema tableSchema, TableSchema dataSchema) {
            List<DataField> allDataFields = this.fieldsExtractor.apply(dataSchema);
            List<DataField> readDataFields = this.readDataFields(allDataFields);
            IndexCastMapping indexCastMapping = SchemaEvolutionUtil.createIndexCastMapping(this.readTableFields, readDataFields);
            Pair<int[], RowType> trimmedKeyPair = Builder.trimKeyFields(readDataFields, allDataFields);
            Pair<Pair<int[], RowType>, List<DataField>> partitionMappingAndFieldsWithoutPartitionPair = PartitionUtils.constructPartitionMapping(dataSchema, trimmedKeyPair.getRight().getFields());
            Pair<int[], RowType> partitionMapping = partitionMappingAndFieldsWithoutPartitionPair.getLeft();
            RowType readRowType = new RowType(partitionMappingAndFieldsWithoutPartitionPair.getRight());
            List<Predicate> readFilters = this.readFilters(this.filters, tableSchema, dataSchema);
            return new FormatReaderMapping(indexCastMapping.getIndexMapping(), indexCastMapping.getCastMapping(), trimmedKeyPair.getLeft(), partitionMapping, this.formatDiscover.discover(formatIdentifier).createReaderFactory(readRowType, readFilters), dataSchema, readFilters);
        }

        static Pair<int[], RowType> trimKeyFields(List<DataField> fieldsWithoutPartition, List<DataField> fields) {
            int[] map = new int[fieldsWithoutPartition.size()];
            ArrayList<DataField> trimmedFields = new ArrayList<DataField>();
            HashMap<Integer, DataField> fieldMap = new HashMap<Integer, DataField>();
            HashMap<Integer, Integer> positionMap = new HashMap<Integer, Integer>();
            for (DataField field : fields) {
                fieldMap.put(field.id(), field);
            }
            for (int i = 0; i < fieldsWithoutPartition.size(); ++i) {
                DataField field;
                field = fieldsWithoutPartition.get(i);
                boolean keyField = SpecialFields.isKeyField(field.name());
                int id = keyField ? field.id() - 0x3FFFFFFF : field.id();
                DataField f = (DataField)fieldMap.get(id);
                if (f != null) {
                    if (positionMap.containsKey(id)) {
                        map[i] = (Integer)positionMap.get(id);
                        continue;
                    }
                    map[i] = positionMap.computeIfAbsent(id, k -> trimmedFields.size());
                    trimmedFields.add(keyField ? f : field);
                    continue;
                }
                throw new RuntimeException("Can't find field with id: " + id + " in fields.");
            }
            return Pair.of(map, new RowType(trimmedFields));
        }

        private List<DataField> readDataFields(List<DataField> allDataFields) {
            ArrayList<DataField> readDataFields = new ArrayList<DataField>();
            for (DataField dataField : allDataFields) {
                this.readTableFields.stream().filter(f -> f.id() == dataField.id()).findFirst().ifPresent(field -> {
                    DataType prunedType = this.pruneDataType(field.type(), dataField.type());
                    if (prunedType != null) {
                        readDataFields.add(dataField.newType(prunedType));
                    }
                });
            }
            return readDataFields;
        }

        @Nullable
        private DataType pruneDataType(DataType readType, DataType dataType) {
            switch (readType.getTypeRoot()) {
                case ROW: {
                    RowType r = (RowType)readType;
                    RowType d = (RowType)dataType;
                    ArrayList<DataField> newFields = new ArrayList<DataField>();
                    for (DataField rf : r.getFields()) {
                        if (!d.containsField(rf.id())) continue;
                        DataField df = d.getField(rf.id());
                        DataType newType = this.pruneDataType(rf.type(), df.type());
                        if (newType == null) continue;
                        newFields.add(df.newType(newType));
                    }
                    if (newFields.isEmpty()) {
                        return null;
                    }
                    return d.copy(newFields);
                }
                case MAP: {
                    DataType keyType = this.pruneDataType(((MapType)readType).getKeyType(), ((MapType)dataType).getKeyType());
                    DataType valueType = this.pruneDataType(((MapType)readType).getValueType(), ((MapType)dataType).getValueType());
                    if (keyType == null || valueType == null) {
                        return null;
                    }
                    return ((MapType)dataType).newKeyValueType(keyType, valueType);
                }
                case ARRAY: {
                    DataType elementType = this.pruneDataType(((ArrayType)readType).getElementType(), ((ArrayType)dataType).getElementType());
                    if (elementType == null) {
                        return null;
                    }
                    return ((ArrayType)dataType).newElementType(elementType);
                }
            }
            return dataType;
        }

        private List<Predicate> readFilters(List<Predicate> filters, TableSchema tableSchema, TableSchema dataSchema) {
            List<Predicate> dataFilters = tableSchema.id() == dataSchema.id() ? filters : SchemaEvolutionUtil.devolveDataFilters(tableSchema.fields(), dataSchema.fields(), filters);
            return PredicateBuilder.excludePredicateWithFields(dataFilters, new HashSet<String>(dataSchema.partitionKeys()));
        }
    }
}

