/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.shade.org.apache.datasketches.theta;

import org.apache.paimon.shade.org.apache.datasketches.memory.Memory;
import org.apache.paimon.shade.org.apache.datasketches.memory.WritableMemory;
import org.apache.paimon.shade.org.apache.datasketches.theta.CompactOperations;
import org.apache.paimon.shade.org.apache.datasketches.theta.CompactSketch;
import org.apache.paimon.shade.org.apache.datasketches.theta.HashIterator;
import org.apache.paimon.shade.org.apache.datasketches.theta.HeapCompactHashIterator;
import org.apache.paimon.shade.org.apache.datasketches.theta.Sketch;

class HeapCompactSketch
extends CompactSketch {
    private final long thetaLong_;
    private final int curCount_;
    private final int preLongs_;
    private final short seedHash_;
    private final boolean empty_;
    private final boolean ordered_;
    private final boolean singleItem_;
    private final long[] cache_;

    HeapCompactSketch(long[] cache, boolean empty, short seedHash, int curCount, long thetaLong, boolean ordered) {
        this.seedHash_ = seedHash;
        this.curCount_ = curCount;
        this.empty_ = empty;
        this.ordered_ = ordered;
        this.cache_ = cache;
        this.thetaLong_ = CompactOperations.correctThetaOnCompact(empty, curCount, thetaLong);
        this.preLongs_ = CompactOperations.computeCompactPreLongs(empty, curCount, thetaLong);
        this.singleItem_ = CompactOperations.isSingleItem(empty, curCount, thetaLong);
        CompactOperations.checkIllegalCurCountAndEmpty(empty, curCount);
    }

    @Override
    public CompactSketch compact(boolean dstOrdered, WritableMemory dstMem) {
        if (!(dstMem != null || dstOrdered && this.ordered_ != dstOrdered)) {
            return this;
        }
        return CompactOperations.componentsToCompact(this.getThetaLong(), this.getRetainedEntries(true), this.getSeedHash(), this.isEmpty(), true, this.ordered_, dstOrdered, dstMem, (long[])this.getCache().clone());
    }

    @Override
    public int getCurrentBytes() {
        return this.preLongs_ + this.curCount_ << 3;
    }

    @Override
    public double getEstimate() {
        return Sketch.estimate(this.thetaLong_, this.curCount_);
    }

    @Override
    public int getRetainedEntries(boolean valid) {
        return this.curCount_;
    }

    @Override
    public long getThetaLong() {
        return this.thetaLong_;
    }

    @Override
    public boolean hasMemory() {
        return false;
    }

    @Override
    public boolean isDirect() {
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.empty_;
    }

    @Override
    public boolean isOrdered() {
        return this.ordered_;
    }

    @Override
    public HashIterator iterator() {
        return new HeapCompactHashIterator(this.cache_);
    }

    @Override
    long[] getCache() {
        return this.cache_;
    }

    @Override
    int getCompactPreambleLongs() {
        return this.preLongs_;
    }

    @Override
    int getCurrentPreambleLongs() {
        return this.preLongs_;
    }

    @Override
    Memory getMemory() {
        return null;
    }

    @Override
    short getSeedHash() {
        return this.seedHash_;
    }

    @Override
    public byte[] toByteArray() {
        int bytes = this.getCurrentBytes();
        byte[] byteArray = new byte[bytes];
        WritableMemory dstMem = WritableMemory.writableWrap(byteArray);
        int emptyBit = this.isEmpty() ? 4 : 0;
        int orderedBit = this.ordered_ ? 16 : 0;
        int singleItemBit = this.singleItem_ ? 32 : 0;
        byte flags = (byte)(emptyBit | 2 | 8 | orderedBit | singleItemBit);
        int preLongs = this.getCompactPreambleLongs();
        CompactOperations.loadCompactMemory(this.getCache(), this.getSeedHash(), this.getRetainedEntries(true), this.getThetaLong(), dstMem, flags, preLongs);
        return byteArray;
    }
}

