/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.shade.org.apache.datasketches.theta;

import org.apache.paimon.shade.org.apache.datasketches.memory.Memory;
import org.apache.paimon.shade.org.apache.datasketches.memory.WritableMemory;
import org.apache.paimon.shade.org.apache.datasketches.theta.CompactOperations;
import org.apache.paimon.shade.org.apache.datasketches.theta.CompactSketch;
import org.apache.paimon.shade.org.apache.datasketches.theta.HashIterator;
import org.apache.paimon.shade.org.apache.datasketches.theta.MemoryHashIterator;
import org.apache.paimon.shade.org.apache.datasketches.theta.PreambleUtil;
import org.apache.paimon.shade.org.apache.datasketches.theta.SingleItemSketch;
import org.apache.paimon.shade.org.apache.datasketches.theta.Sketch;
import org.apache.paimon.shade.org.apache.datasketches.thetacommon.ThetaUtil;

class DirectCompactSketch
extends CompactSketch {
    final Memory mem_;

    DirectCompactSketch(Memory mem) {
        this.mem_ = mem;
    }

    static DirectCompactSketch wrapInstance(Memory srcMem, short seedHash) {
        ThetaUtil.checkSeedHashes((short)PreambleUtil.extractSeedHash(srcMem), seedHash);
        return new DirectCompactSketch(srcMem);
    }

    @Override
    public CompactSketch compact(boolean dstOrdered, WritableMemory dstMem) {
        return CompactOperations.memoryToCompact(this.mem_, dstOrdered, dstMem);
    }

    @Override
    public int getCurrentBytes() {
        if (SingleItemSketch.otherCheckForSingleItem(this.mem_)) {
            return 16;
        }
        int preLongs = PreambleUtil.extractPreLongs(this.mem_);
        int curCount = preLongs == 1 ? 0 : PreambleUtil.extractCurCount(this.mem_);
        return preLongs + curCount << 3;
    }

    @Override
    public double getEstimate() {
        if (SingleItemSketch.otherCheckForSingleItem(this.mem_)) {
            return 1.0;
        }
        int preLongs = PreambleUtil.extractPreLongs(this.mem_);
        int curCount = preLongs == 1 ? 0 : PreambleUtil.extractCurCount(this.mem_);
        long thetaLong = preLongs > 2 ? PreambleUtil.extractThetaLong(this.mem_) : Long.MAX_VALUE;
        return Sketch.estimate(thetaLong, curCount);
    }

    @Override
    public int getRetainedEntries(boolean valid) {
        if (SingleItemSketch.otherCheckForSingleItem(this.mem_)) {
            return 1;
        }
        int preLongs = PreambleUtil.extractPreLongs(this.mem_);
        int curCount = preLongs == 1 ? 0 : PreambleUtil.extractCurCount(this.mem_);
        return curCount;
    }

    @Override
    public long getThetaLong() {
        int preLongs = PreambleUtil.extractPreLongs(this.mem_);
        return preLongs > 2 ? PreambleUtil.extractThetaLong(this.mem_) : Long.MAX_VALUE;
    }

    @Override
    public boolean hasMemory() {
        return true;
    }

    @Override
    public boolean isDirect() {
        return this.mem_.isDirect();
    }

    @Override
    public boolean isEmpty() {
        boolean emptyFlag = PreambleUtil.isEmptyFlag(this.mem_);
        long thetaLong = this.getThetaLong();
        int curCount = this.getRetainedEntries(true);
        return emptyFlag || curCount == 0 && thetaLong == Long.MAX_VALUE;
    }

    @Override
    public boolean isOrdered() {
        return (PreambleUtil.extractFlags(this.mem_) & 0x10) > 0;
    }

    @Override
    public boolean isSameResource(Memory that) {
        return this.mem_.isSameResource(that);
    }

    @Override
    public HashIterator iterator() {
        return new MemoryHashIterator(this.mem_, this.getRetainedEntries(true), this.getThetaLong());
    }

    @Override
    public byte[] toByteArray() {
        int curCount = this.getRetainedEntries(true);
        CompactOperations.checkIllegalCurCountAndEmpty(this.isEmpty(), curCount);
        int preLongs = PreambleUtil.extractPreLongs(this.mem_);
        int outBytes = curCount + preLongs << 3;
        byte[] byteArrOut = new byte[outBytes];
        this.mem_.getByteArray(0L, byteArrOut, 0, outBytes);
        return byteArrOut;
    }

    @Override
    long[] getCache() {
        int curCount;
        if (SingleItemSketch.otherCheckForSingleItem(this.mem_)) {
            return new long[]{this.mem_.getLong(8L)};
        }
        int preLongs = PreambleUtil.extractPreLongs(this.mem_);
        int n = curCount = preLongs == 1 ? 0 : PreambleUtil.extractCurCount(this.mem_);
        if (curCount > 0) {
            long[] cache = new long[curCount];
            this.mem_.getLongArray(preLongs << 3, cache, 0, curCount);
            return cache;
        }
        return new long[0];
    }

    @Override
    int getCompactPreambleLongs() {
        return PreambleUtil.extractPreLongs(this.mem_);
    }

    @Override
    int getCurrentPreambleLongs() {
        return PreambleUtil.extractPreLongs(this.mem_);
    }

    @Override
    Memory getMemory() {
        return this.mem_;
    }

    @Override
    short getSeedHash() {
        return (short)PreambleUtil.extractSeedHash(this.mem_);
    }
}

