/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.manifest;

import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.paimon.annotation.Public;
import org.apache.paimon.manifest.ManifestFileMetaSerializer;
import org.apache.paimon.stats.SimpleStats;
import org.apache.paimon.types.BigIntType;
import org.apache.paimon.types.DataField;
import org.apache.paimon.types.IntType;
import org.apache.paimon.types.RowType;
import org.apache.paimon.types.VarCharType;

@Public
public class ManifestFileMeta {
    public static final RowType SCHEMA = new RowType(false, Arrays.asList(new DataField(0, "_FILE_NAME", new VarCharType(false, Integer.MAX_VALUE)), new DataField(1, "_FILE_SIZE", new BigIntType(false)), new DataField(2, "_NUM_ADDED_FILES", new BigIntType(false)), new DataField(3, "_NUM_DELETED_FILES", new BigIntType(false)), new DataField(4, "_PARTITION_STATS", SimpleStats.SCHEMA), new DataField(5, "_SCHEMA_ID", new BigIntType(false)), new DataField(6, "_MIN_BUCKET", new IntType(true)), new DataField(7, "_MAX_BUCKET", new IntType(true)), new DataField(8, "_MIN_LEVEL", new IntType(true)), new DataField(9, "_MAX_LEVEL", new IntType(true))));
    private final String fileName;
    private final long fileSize;
    private final long numAddedFiles;
    private final long numDeletedFiles;
    private final SimpleStats partitionStats;
    private final long schemaId;
    @Nullable
    private final Integer minBucket;
    @Nullable
    private final Integer maxBucket;
    @Nullable
    private final Integer minLevel;
    @Nullable
    private final Integer maxLevel;
    private static final ThreadLocal<ManifestFileMetaSerializer> SERIALIZER_THREAD_LOCAL = ThreadLocal.withInitial(ManifestFileMetaSerializer::new);

    public ManifestFileMeta(String fileName, long fileSize, long numAddedFiles, long numDeletedFiles, SimpleStats partitionStats, long schemaId, @Nullable Integer minBucket, @Nullable Integer maxBucket, @Nullable Integer minLevel, @Nullable Integer maxLevel) {
        this.fileName = fileName;
        this.fileSize = fileSize;
        this.numAddedFiles = numAddedFiles;
        this.numDeletedFiles = numDeletedFiles;
        this.partitionStats = partitionStats;
        this.schemaId = schemaId;
        this.minBucket = minBucket;
        this.maxBucket = maxBucket;
        this.minLevel = minLevel;
        this.maxLevel = maxLevel;
    }

    public String fileName() {
        return this.fileName;
    }

    public long fileSize() {
        return this.fileSize;
    }

    public long numAddedFiles() {
        return this.numAddedFiles;
    }

    public long numDeletedFiles() {
        return this.numDeletedFiles;
    }

    public SimpleStats partitionStats() {
        return this.partitionStats;
    }

    public long schemaId() {
        return this.schemaId;
    }

    @Nullable
    public Integer minBucket() {
        return this.minBucket;
    }

    @Nullable
    public Integer maxBucket() {
        return this.maxBucket;
    }

    @Nullable
    public Integer minLevel() {
        return this.minLevel;
    }

    @Nullable
    public Integer maxLevel() {
        return this.maxLevel;
    }

    public boolean equals(Object o) {
        if (!(o instanceof ManifestFileMeta)) {
            return false;
        }
        ManifestFileMeta that = (ManifestFileMeta)o;
        return Objects.equals(this.fileName, that.fileName) && this.fileSize == that.fileSize && this.numAddedFiles == that.numAddedFiles && this.numDeletedFiles == that.numDeletedFiles && Objects.equals(this.partitionStats, that.partitionStats) && this.schemaId == that.schemaId && Objects.equals(this.minBucket, that.minBucket) && Objects.equals(this.maxBucket, that.maxBucket) && Objects.equals(this.minLevel, that.minLevel) && Objects.equals(this.maxLevel, that.maxLevel);
    }

    public int hashCode() {
        return Objects.hash(this.fileName, this.fileSize, this.numAddedFiles, this.numDeletedFiles, this.partitionStats, this.schemaId, this.minBucket, this.maxBucket, this.minLevel, this.maxLevel);
    }

    public String toString() {
        return String.format("{%s, %d, %d, %d, %s, %d, %s, %s, %s, %s}", this.fileName, this.fileSize, this.numAddedFiles, this.numDeletedFiles, this.partitionStats, this.schemaId, this.minBucket, this.maxBucket, this.minLevel, this.maxLevel);
    }

    public byte[] toBytes() throws IOException {
        return SERIALIZER_THREAD_LOCAL.get().serializeToBytes(this);
    }

    public ManifestFileMeta fromBytes(byte[] bytes) throws IOException {
        return (ManifestFileMeta)SERIALIZER_THREAD_LOCAL.get().deserializeFromBytes(bytes);
    }
}

