/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.iceberg.metadata;

import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.paimon.iceberg.metadata.IcebergDataTypeDeserializer;
import org.apache.paimon.iceberg.metadata.IcebergListType;
import org.apache.paimon.iceberg.metadata.IcebergMapType;
import org.apache.paimon.iceberg.metadata.IcebergStructType;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.annotation.JsonGetter;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.annotation.JsonIgnore;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import org.apache.paimon.table.SpecialFields;
import org.apache.paimon.types.ArrayType;
import org.apache.paimon.types.BigIntType;
import org.apache.paimon.types.BinaryType;
import org.apache.paimon.types.BooleanType;
import org.apache.paimon.types.DataField;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.DateType;
import org.apache.paimon.types.DecimalType;
import org.apache.paimon.types.DoubleType;
import org.apache.paimon.types.FloatType;
import org.apache.paimon.types.IntType;
import org.apache.paimon.types.LocalZonedTimestampType;
import org.apache.paimon.types.MapType;
import org.apache.paimon.types.RowType;
import org.apache.paimon.types.TimestampType;
import org.apache.paimon.types.VarBinaryType;
import org.apache.paimon.types.VarCharType;
import org.apache.paimon.utils.Preconditions;

@JsonIgnoreProperties(ignoreUnknown=true)
public class IcebergDataField {
    private static final String FIELD_ID = "id";
    private static final String FIELD_NAME = "name";
    private static final String FIELD_REQUIRED = "required";
    private static final String FIELD_TYPE = "type";
    private static final String FIELD_DOC = "doc";
    @JsonProperty(value="id")
    private final int id;
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="required")
    private final boolean required;
    @JsonProperty(value="type")
    @JsonDeserialize(using=IcebergDataTypeDeserializer.class)
    private final Object type;
    @JsonIgnore
    private DataType dataType;
    @JsonProperty(value="doc")
    private final String doc;

    public IcebergDataField(DataField dataField) {
        this(dataField.id(), dataField.name(), !dataField.type().isNullable(), IcebergDataField.toTypeObject(dataField.type(), dataField.id(), 0), dataField.type(), dataField.description());
    }

    @JsonCreator
    public IcebergDataField(@JsonProperty(value="id") int id, @JsonProperty(value="name") String name, @JsonProperty(value="required") boolean required, @JsonProperty(value="type") Object type, @JsonProperty(value="doc") String doc) {
        this(id, name, required, type, null, doc);
    }

    public IcebergDataField(int id, String name, boolean required, Object type, DataType dataType, String doc) {
        this.id = id;
        this.name = name;
        this.required = required;
        this.type = type;
        this.dataType = dataType;
        this.doc = doc;
    }

    @JsonGetter(value="id")
    public int id() {
        return this.id;
    }

    @JsonGetter(value="name")
    public String name() {
        return this.name;
    }

    @JsonGetter(value="required")
    public boolean required() {
        return this.required;
    }

    @JsonGetter(value="type")
    public Object type() {
        return this.type;
    }

    @JsonGetter(value="doc")
    public String doc() {
        return this.doc;
    }

    @JsonIgnore
    public DataType dataType() {
        if (this.dataType != null) {
            return this.dataType;
        }
        this.dataType = this.getDataTypeFromType(this.type, this.required);
        return Preconditions.checkNotNull(this.dataType);
    }

    private static Object toTypeObject(DataType dataType, int fieldId, int depth) {
        switch (dataType.getTypeRoot()) {
            case BOOLEAN: {
                return "boolean";
            }
            case INTEGER: {
                return "int";
            }
            case BIGINT: {
                return "long";
            }
            case FLOAT: {
                return "float";
            }
            case DOUBLE: {
                return "double";
            }
            case DATE: {
                return "date";
            }
            case CHAR: 
            case VARCHAR: {
                return "string";
            }
            case BINARY: 
            case VARBINARY: {
                return "binary";
            }
            case DECIMAL: {
                DecimalType decimalType = (DecimalType)dataType;
                return String.format("decimal(%d, %d)", decimalType.getPrecision(), decimalType.getScale());
            }
            case TIMESTAMP_WITHOUT_TIME_ZONE: {
                int timestampPrecision = ((TimestampType)dataType).getPrecision();
                Preconditions.checkArgument(timestampPrecision > 3 && timestampPrecision <= 6, "Paimon Iceberg compatibility only support timestamp type with precision from 4 to 6.");
                return "timestamp";
            }
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                int timestampLtzPrecision = ((LocalZonedTimestampType)dataType).getPrecision();
                Preconditions.checkArgument(timestampLtzPrecision > 3 && timestampLtzPrecision <= 6, "Paimon Iceberg compatibility only support timestamp type with precision from 4 to 6.");
                return "timestamptz";
            }
            case ARRAY: {
                ArrayType arrayType = (ArrayType)dataType;
                return new IcebergListType(SpecialFields.getArrayElementFieldId(fieldId, depth + 1), !dataType.isNullable(), IcebergDataField.toTypeObject(arrayType.getElementType(), fieldId, depth + 1));
            }
            case MAP: {
                MapType mapType = (MapType)dataType;
                return new IcebergMapType(SpecialFields.getMapKeyFieldId(fieldId, depth + 1), IcebergDataField.toTypeObject(mapType.getKeyType(), fieldId, depth + 1), SpecialFields.getMapValueFieldId(fieldId, depth + 1), !mapType.getValueType().isNullable(), IcebergDataField.toTypeObject(mapType.getValueType(), fieldId, depth + 1));
            }
            case ROW: {
                RowType rowType = (RowType)dataType;
                return new IcebergStructType(rowType.getFields().stream().map(IcebergDataField::new).collect(Collectors.toList()));
            }
        }
        throw new UnsupportedOperationException("Unsupported data type: " + dataType);
    }

    private DataType getDataTypeFromType(Object icebergType, boolean isRequired) {
        if (icebergType instanceof String) {
            String typePrefix;
            String simpleType = icebergType.toString();
            String delimiter = "(";
            if (simpleType.contains("[")) {
                delimiter = "[";
            }
            switch (typePrefix = !simpleType.contains(delimiter) ? simpleType : simpleType.substring(0, simpleType.indexOf(delimiter))) {
                case "boolean": {
                    return new BooleanType(!isRequired);
                }
                case "int": {
                    return new IntType(!isRequired);
                }
                case "long": {
                    return new BigIntType(!isRequired);
                }
                case "float": {
                    return new FloatType(!isRequired);
                }
                case "double": {
                    return new DoubleType(!isRequired);
                }
                case "date": {
                    return new DateType(!isRequired);
                }
                case "string": {
                    return new VarCharType(!isRequired, Integer.MAX_VALUE);
                }
                case "binary": {
                    return new VarBinaryType(!isRequired, Integer.MAX_VALUE);
                }
                case "fixed": {
                    int fixedLength = Integer.parseInt(simpleType.substring(simpleType.indexOf("[") + 1, simpleType.indexOf("]")));
                    return new BinaryType(!isRequired, fixedLength);
                }
                case "uuid": {
                    return new BinaryType(!isRequired, 16);
                }
                case "decimal": {
                    int precision = Integer.parseInt(simpleType.substring(simpleType.indexOf("(") + 1, simpleType.indexOf(",")));
                    int scale = Integer.parseInt(simpleType.substring(simpleType.indexOf(",") + 2, simpleType.indexOf(")")));
                    return new DecimalType(!isRequired, precision, scale);
                }
                case "timestamp": {
                    return new TimestampType(!isRequired, 6);
                }
                case "timestamptz": {
                    return new LocalZonedTimestampType(!isRequired, 6);
                }
                case "timestamp_ns": {
                    return new TimestampType(!isRequired, 9);
                }
                case "timestamptz_ns": {
                    return new LocalZonedTimestampType(!isRequired, 9);
                }
            }
            throw new UnsupportedOperationException("Unsupported primitive data type: " + icebergType);
        }
        if (icebergType instanceof IcebergListType) {
            IcebergListType listType = (IcebergListType)icebergType;
            return new ArrayType(!isRequired, this.getDataTypeFromType(listType.element(), !listType.elementRequired()));
        }
        if (icebergType instanceof IcebergMapType) {
            IcebergMapType mapType = (IcebergMapType)icebergType;
            return new MapType(!isRequired, this.getDataTypeFromType(mapType.key(), true), this.getDataTypeFromType(mapType.value(), !mapType.valueRequired()));
        }
        if (icebergType instanceof IcebergStructType) {
            IcebergStructType structType = (IcebergStructType)icebergType;
            return new RowType(!isRequired, structType.fields().stream().map(IcebergDataField::toDatafield).collect(Collectors.toList()));
        }
        throw new UnsupportedOperationException("Unsupported nested data type: " + icebergType.getClass());
    }

    public DataField toDatafield() {
        return new DataField(this.id, this.name, this.dataType(), this.doc);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.required, this.type, this.doc);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IcebergDataField)) {
            return false;
        }
        IcebergDataField that = (IcebergDataField)o;
        return this.id == that.id && Objects.equals(this.name, that.name) && this.required == that.required && Objects.equals(this.type, that.type) && Objects.equals(this.doc, that.doc);
    }
}

