/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.format.parquet.reader;

import org.apache.paimon.data.Decimal;
import org.apache.paimon.data.columnar.BytesColumnVector;
import org.apache.paimon.data.columnar.ColumnVector;
import org.apache.paimon.data.columnar.DecimalColumnVector;
import org.apache.paimon.data.columnar.Dictionary;
import org.apache.paimon.data.columnar.IntColumnVector;
import org.apache.paimon.data.columnar.LongColumnVector;
import org.apache.paimon.data.columnar.heap.ElementCountable;
import org.apache.paimon.data.columnar.writable.WritableBytesVector;
import org.apache.paimon.data.columnar.writable.WritableColumnVector;
import org.apache.paimon.data.columnar.writable.WritableIntVector;
import org.apache.paimon.data.columnar.writable.WritableLongVector;
import org.apache.paimon.format.parquet.ParquetSchemaConverter;
import org.apache.paimon.utils.Preconditions;

public class ParquetDecimalVector
implements DecimalColumnVector,
WritableLongVector,
WritableIntVector,
WritableBytesVector,
ElementCountable {
    private final WritableColumnVector vector;

    public ParquetDecimalVector(WritableColumnVector vector) {
        this.vector = vector;
    }

    @Override
    public Decimal getDecimal(int i, int precision, int scale) {
        if (ParquetSchemaConverter.is32BitDecimal(precision) && this.vector instanceof IntColumnVector) {
            return Decimal.fromUnscaledLong(((IntColumnVector)((Object)this.vector)).getInt(i), precision, scale);
        }
        if (ParquetSchemaConverter.is64BitDecimal(precision) && this.vector instanceof LongColumnVector) {
            return Decimal.fromUnscaledLong(((LongColumnVector)((Object)this.vector)).getLong(i), precision, scale);
        }
        Preconditions.checkArgument(this.vector instanceof BytesColumnVector, "Reading decimal type occur unsupported vector type: %s", this.vector.getClass());
        return Decimal.fromUnscaledBytes(((BytesColumnVector)((Object)this.vector)).getBytes(i).getBytes(), precision, scale);
    }

    public ColumnVector getVector() {
        return this.vector;
    }

    @Override
    public boolean isNullAt(int i) {
        return this.vector.isNullAt(i);
    }

    @Override
    public int getCapacity() {
        return this.vector.getCapacity();
    }

    @Override
    public void reset() {
        this.vector.reset();
    }

    @Override
    public void setNullAt(int rowId) {
        this.vector.setNullAt(rowId);
    }

    @Override
    public void setNulls(int rowId, int count) {
        this.vector.setNulls(rowId, count);
    }

    @Override
    public void fillWithNulls() {
        this.vector.fillWithNulls();
    }

    @Override
    public void setDictionary(Dictionary dictionary) {
        this.vector.setDictionary(dictionary);
    }

    @Override
    public boolean hasDictionary() {
        return this.vector.hasDictionary();
    }

    @Override
    public WritableIntVector reserveDictionaryIds(int capacity) {
        return this.vector.reserveDictionaryIds(capacity);
    }

    @Override
    public WritableIntVector getDictionaryIds() {
        return this.vector.getDictionaryIds();
    }

    @Override
    public void setAllNull() {
        this.vector.setAllNull();
    }

    @Override
    public boolean isAllNull() {
        return this.vector.isAllNull();
    }

    @Override
    public void reserve(int capacity) {
        this.vector.reserve(capacity);
    }

    @Override
    public int getElementsAppended() {
        return this.vector.getElementsAppended();
    }

    @Override
    public void addElementsAppended(int num) {
        this.vector.addElementsAppended(num);
    }

    @Override
    public BytesColumnVector.Bytes getBytes(int i) {
        if (this.vector instanceof WritableBytesVector) {
            return ((WritableBytesVector)this.vector).getBytes(i);
        }
        throw new RuntimeException("Child vector must be instance of WritableColumnVector");
    }

    @Override
    public void putByteArray(int rowId, byte[] value, int offset, int length) {
        if (this.vector instanceof WritableBytesVector) {
            ((WritableBytesVector)this.vector).putByteArray(rowId, value, offset, length);
        }
    }

    @Override
    public void fill(byte[] value) {
        if (this.vector instanceof WritableBytesVector) {
            ((WritableBytesVector)this.vector).fill(value);
        }
    }

    @Override
    public int getInt(int i) {
        if (this.vector instanceof WritableIntVector) {
            return ((WritableIntVector)this.vector).getInt(i);
        }
        throw new RuntimeException("Child vector must be instance of WritableColumnVector");
    }

    @Override
    public void setInt(int rowId, int value) {
        if (this.vector instanceof WritableIntVector) {
            ((WritableIntVector)this.vector).setInt(rowId, value);
        }
    }

    @Override
    public void setIntsFromBinary(int rowId, int count, byte[] src, int srcIndex) {
        if (this.vector instanceof WritableIntVector) {
            ((WritableIntVector)this.vector).setIntsFromBinary(rowId, count, src, srcIndex);
        }
    }

    @Override
    public void setInts(int rowId, int count, int value) {
        if (this.vector instanceof WritableIntVector) {
            ((WritableIntVector)this.vector).setInts(rowId, count, value);
        }
    }

    @Override
    public void setInts(int rowId, int count, int[] src, int srcIndex) {
        if (this.vector instanceof WritableIntVector) {
            ((WritableIntVector)this.vector).setInts(rowId, count, src, srcIndex);
        }
    }

    @Override
    public void fill(int value) {
        if (this.vector instanceof WritableIntVector) {
            ((WritableIntVector)this.vector).fill(value);
        }
    }

    @Override
    public void appendInt(int v) {
        if (this.vector instanceof WritableIntVector) {
            ((WritableIntVector)this.vector).appendInt(v);
        }
    }

    @Override
    public void appendInts(int count, int v) {
        if (this.vector instanceof WritableIntVector) {
            ((WritableIntVector)this.vector).appendInts(count, v);
        }
    }

    @Override
    public long getLong(int i) {
        if (this.vector instanceof WritableLongVector) {
            return ((WritableLongVector)this.vector).getLong(i);
        }
        throw new RuntimeException("Child vector must be instance of WritableColumnVector");
    }

    @Override
    public void setLong(int rowId, long value) {
        if (this.vector instanceof WritableLongVector) {
            ((WritableLongVector)this.vector).setLong(rowId, value);
        }
    }

    @Override
    public void setLongsFromBinary(int rowId, int count, byte[] src, int srcIndex) {
        if (this.vector instanceof WritableLongVector) {
            ((WritableLongVector)this.vector).setLongsFromBinary(rowId, count, src, srcIndex);
        }
    }

    @Override
    public void fill(long value) {
        if (this.vector instanceof WritableLongVector) {
            ((WritableLongVector)this.vector).fill(value);
        }
    }
}

