/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.casting;

import org.apache.paimon.casting.AbstractCastRule;
import org.apache.paimon.casting.CastExecutor;
import org.apache.paimon.casting.CastRulePredicate;
import org.apache.paimon.data.Decimal;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.DataTypeRoot;
import org.apache.paimon.types.DecimalType;
import org.apache.paimon.utils.DecimalUtils;

class DecimalToDecimalCastRule
extends AbstractCastRule<Decimal, Decimal> {
    static final DecimalToDecimalCastRule INSTANCE = new DecimalToDecimalCastRule();

    private DecimalToDecimalCastRule() {
        super(CastRulePredicate.builder().input(DataTypeRoot.DECIMAL).target(DataTypeRoot.DECIMAL).build());
    }

    @Override
    public CastExecutor<Decimal, Decimal> create(DataType inputType, DataType targetType) {
        DecimalType decimalType = (DecimalType)targetType;
        return value -> DecimalUtils.castToDecimal(value, decimalType.getPrecision(), decimalType.getScale());
    }
}

