/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fluss.lake.paimon.tiering;

import java.io.IOException;
import org.apache.fluss.lake.paimon.tiering.PaimonWriteResult;
import org.apache.fluss.lake.serializer.SimpleVersionedSerializer;
import org.apache.paimon.table.sink.CommitMessage;
import org.apache.paimon.table.sink.CommitMessageSerializer;

public class PaimonWriteResultSerializer
implements SimpleVersionedSerializer<PaimonWriteResult> {
    private static final int CURRENT_VERSION = 1;
    private final CommitMessageSerializer messageSer = new CommitMessageSerializer();

    public int getVersion() {
        return 1;
    }

    public byte[] serialize(PaimonWriteResult paimonWriteResult) throws IOException {
        CommitMessage commitMessage = paimonWriteResult.commitMessage();
        return this.messageSer.serialize(commitMessage);
    }

    public PaimonWriteResult deserialize(int version, byte[] serialized) throws IOException {
        if (version != 1) {
            throw new UnsupportedOperationException("Expecting PaimonWriteResult version to be 1, but found " + version + ".");
        }
        CommitMessage commitMessage = this.messageSer.deserialize(this.messageSer.getVersion(), serialized);
        return new PaimonWriteResult(commitMessage);
    }
}

