/*
 * Decompiled with CFR 0.152.
 */
package org.jets3t.service.multi.s3;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jets3t.service.S3Service;
import org.jets3t.service.ServiceException;
import org.jets3t.service.io.BytesProgressWatcher;
import org.jets3t.service.io.InterruptableInputStream;
import org.jets3t.service.io.ProgressMonitoredInputStream;
import org.jets3t.service.model.MultipartCompleted;
import org.jets3t.service.model.MultipartUpload;
import org.jets3t.service.model.S3Object;
import org.jets3t.service.model.StorageObject;
import org.jets3t.service.multi.StorageServiceEventListener;
import org.jets3t.service.multi.ThreadWatcher;
import org.jets3t.service.multi.ThreadedStorageService;
import org.jets3t.service.multi.event.ServiceEvent;
import org.jets3t.service.multi.s3.MultipartCompletesEvent;
import org.jets3t.service.multi.s3.MultipartStartsEvent;
import org.jets3t.service.multi.s3.MultipartUploadAndParts;
import org.jets3t.service.multi.s3.MultipartUploadsEvent;
import org.jets3t.service.multi.s3.S3ServiceEventListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThreadedS3Service
extends ThreadedStorageService {
    private static final Log log = LogFactory.getLog(ThreadedS3Service.class);

    public ThreadedS3Service(S3Service service, StorageServiceEventListener listener) throws ServiceException {
        super(service, listener);
    }

    @Override
    protected void fireServiceEvent(ServiceEvent event) {
        if (this.serviceEventListeners.size() == 0 && log.isWarnEnabled()) {
            log.warn("ThreadedS3Service invoked without any StorageServiceEventListener objects, this is dangerous!");
        }
        for (StorageServiceEventListener listener : this.serviceEventListeners) {
            if (listener instanceof S3ServiceEventListener) {
                if (event instanceof MultipartUploadsEvent) {
                    ((S3ServiceEventListener)listener).event((MultipartUploadsEvent)event);
                    continue;
                }
                if (event instanceof MultipartStartsEvent) {
                    ((S3ServiceEventListener)listener).event((MultipartStartsEvent)event);
                    continue;
                }
                if (event instanceof MultipartCompletesEvent) {
                    ((S3ServiceEventListener)listener).event((MultipartCompletesEvent)event);
                    continue;
                }
                super.fireServiceEvent(event);
                continue;
            }
            super.fireServiceEvent(event);
        }
    }

    private void assertIsS3Service() {
        if (!(this.storageService instanceof S3Service)) {
            throw new IllegalStateException("Multipart uploads are only available in Amazon S3, you must use the S3Service implementation of StorageService");
        }
    }

    public boolean multipartStartUploads(String bucketName, List<StorageObject> objects) {
        this.assertIsS3Service();
        final ArrayList<StorageObject> incompletedObjectsList = new ArrayList<StorageObject>();
        final Object uniqueOperationId = new Object();
        final boolean[] success = new boolean[]{true};
        ArrayList<MultipartStartRunnable> runnableList = new ArrayList<MultipartStartRunnable>();
        for (StorageObject object : objects) {
            incompletedObjectsList.add(object);
            runnableList.add(new MultipartStartRunnable(bucketName, object));
        }
        ThreadWatcher threadWatcher = new ThreadWatcher(runnableList.size());
        new ThreadedStorageService.ThreadGroupManager(runnableList.toArray(new MultipartStartRunnable[0]), threadWatcher, this.storageService.getJetS3tProperties(), true){

            public void fireStartEvent(ThreadWatcher threadWatcher) {
                ThreadedS3Service.this.fireServiceEvent(MultipartStartsEvent.newStartedEvent(threadWatcher, uniqueOperationId));
            }

            public void fireProgressEvent(ThreadWatcher threadWatcher, List completedResults) {
                MultipartUpload[] completedObjects = completedResults.toArray(new MultipartUpload[completedResults.size()]);
                ArrayList<StorageObject> completedStorageObjects = new ArrayList<StorageObject>();
                for (MultipartUpload upload : completedObjects) {
                    for (StorageObject object : incompletedObjectsList) {
                        if (!object.getKey().equals(upload.getObjectKey())) continue;
                        completedStorageObjects.add(object);
                    }
                }
                incompletedObjectsList.removeAll(completedStorageObjects);
                ThreadedS3Service.this.fireServiceEvent(MultipartStartsEvent.newInProgressEvent(threadWatcher, completedObjects, uniqueOperationId));
            }

            public void fireCancelEvent() {
                StorageObject[] incompletedObjects = incompletedObjectsList.toArray(new StorageObject[incompletedObjectsList.size()]);
                success[0] = false;
                ThreadedS3Service.this.fireServiceEvent(MultipartStartsEvent.newCancelledEvent(incompletedObjects, uniqueOperationId));
            }

            public void fireCompletedEvent() {
                ThreadedS3Service.this.fireServiceEvent(MultipartStartsEvent.newCompletedEvent(uniqueOperationId));
            }

            public void fireErrorEvent(Throwable throwable) {
                success[0] = false;
                ThreadedS3Service.this.fireServiceEvent(MultipartStartsEvent.newErrorEvent(throwable, uniqueOperationId));
            }

            public void fireIgnoredErrorsEvent(ThreadWatcher threadWatcher, Throwable[] ignoredErrors) {
                success[0] = false;
                ThreadedS3Service.this.fireServiceEvent(MultipartStartsEvent.newIgnoredErrorsEvent(threadWatcher, ignoredErrors, uniqueOperationId));
            }
        }.run();
        return success[0];
    }

    public boolean multipartCompleteUploads(List<MultipartUpload> multipartUploads) {
        this.assertIsS3Service();
        final ArrayList<MultipartUpload> incompletedObjectsList = new ArrayList<MultipartUpload>();
        final Object uniqueOperationId = new Object();
        final boolean[] success = new boolean[]{true};
        ArrayList<MultipartCompleteRunnable> runnableList = new ArrayList<MultipartCompleteRunnable>();
        for (MultipartUpload multipartUpload : multipartUploads) {
            incompletedObjectsList.add(multipartUpload);
            runnableList.add(new MultipartCompleteRunnable(multipartUpload));
        }
        ThreadWatcher threadWatcher = new ThreadWatcher(runnableList.size());
        new ThreadedStorageService.ThreadGroupManager(runnableList.toArray(new MultipartCompleteRunnable[0]), threadWatcher, this.storageService.getJetS3tProperties(), true){

            public void fireStartEvent(ThreadWatcher threadWatcher) {
                ThreadedS3Service.this.fireServiceEvent(MultipartCompletesEvent.newStartedEvent(threadWatcher, uniqueOperationId));
            }

            public void fireProgressEvent(ThreadWatcher threadWatcher, List completedResults) {
                incompletedObjectsList.removeAll(completedResults);
                MultipartCompleted[] completedObjects = completedResults.toArray(new MultipartCompleted[completedResults.size()]);
                ThreadedS3Service.this.fireServiceEvent(MultipartCompletesEvent.newInProgressEvent(threadWatcher, completedObjects, uniqueOperationId));
            }

            public void fireCancelEvent() {
                MultipartUpload[] incompletedObjects = incompletedObjectsList.toArray(new MultipartUpload[incompletedObjectsList.size()]);
                success[0] = false;
                ThreadedS3Service.this.fireServiceEvent(MultipartCompletesEvent.newCancelledEvent(incompletedObjects, uniqueOperationId));
            }

            public void fireCompletedEvent() {
                ThreadedS3Service.this.fireServiceEvent(MultipartCompletesEvent.newCompletedEvent(uniqueOperationId));
            }

            public void fireErrorEvent(Throwable throwable) {
                success[0] = false;
                ThreadedS3Service.this.fireServiceEvent(MultipartCompletesEvent.newErrorEvent(throwable, uniqueOperationId));
            }

            public void fireIgnoredErrorsEvent(ThreadWatcher threadWatcher, Throwable[] ignoredErrors) {
                success[0] = false;
                ThreadedS3Service.this.fireServiceEvent(MultipartCompletesEvent.newIgnoredErrorsEvent(threadWatcher, ignoredErrors, uniqueOperationId));
            }
        }.run();
        return success[0];
    }

    public boolean multipartUploadParts(List<MultipartUploadAndParts> uploadAndPartsList) {
        this.assertIsS3Service();
        final ArrayList<S3Object> incompletedObjectsList = new ArrayList<S3Object>();
        ArrayList<BytesProgressWatcher> progressWatchers = new ArrayList<BytesProgressWatcher>();
        final Object uniqueOperationId = new Object();
        final boolean[] success = new boolean[]{true};
        ArrayList<MultipartUploadObjectRunnable> runnableList = new ArrayList<MultipartUploadObjectRunnable>();
        for (MultipartUploadAndParts multipartUploadAndParts : uploadAndPartsList) {
            int partNumber = multipartUploadAndParts.getPartNumberOffset();
            for (S3Object partObject : multipartUploadAndParts.getPartObjects()) {
                incompletedObjectsList.add(partObject);
                BytesProgressWatcher progressMonitor = new BytesProgressWatcher(partObject.getContentLength());
                runnableList.add(new MultipartUploadObjectRunnable(multipartUploadAndParts.getMultipartUpload(), partNumber, partObject, progressMonitor));
                progressWatchers.add(progressMonitor);
                ++partNumber;
            }
        }
        ThreadWatcher threadWatcher = new ThreadWatcher(progressWatchers.toArray(new BytesProgressWatcher[progressWatchers.size()]));
        new ThreadedStorageService.ThreadGroupManager(runnableList.toArray(new MultipartUploadObjectRunnable[0]), threadWatcher, this.storageService.getJetS3tProperties(), false){

            public void fireStartEvent(ThreadWatcher threadWatcher) {
                ThreadedS3Service.this.fireServiceEvent(MultipartUploadsEvent.newStartedEvent(threadWatcher, uniqueOperationId));
            }

            public void fireProgressEvent(ThreadWatcher threadWatcher, List completedResults) {
                incompletedObjectsList.removeAll(completedResults);
                StorageObject[] completedObjects = completedResults.toArray(new StorageObject[completedResults.size()]);
                ThreadedS3Service.this.fireServiceEvent(MultipartUploadsEvent.newInProgressEvent(threadWatcher, completedObjects, uniqueOperationId));
            }

            public void fireCancelEvent() {
                StorageObject[] incompletedObjects = incompletedObjectsList.toArray(new StorageObject[incompletedObjectsList.size()]);
                success[0] = false;
                ThreadedS3Service.this.fireServiceEvent(MultipartUploadsEvent.newCancelledEvent(incompletedObjects, uniqueOperationId));
            }

            public void fireCompletedEvent() {
                ThreadedS3Service.this.fireServiceEvent(MultipartUploadsEvent.newCompletedEvent(uniqueOperationId));
            }

            public void fireErrorEvent(Throwable throwable) {
                success[0] = false;
                ThreadedS3Service.this.fireServiceEvent(MultipartUploadsEvent.newErrorEvent(throwable, uniqueOperationId));
            }

            public void fireIgnoredErrorsEvent(ThreadWatcher threadWatcher, Throwable[] ignoredErrors) {
                success[0] = false;
                ThreadedS3Service.this.fireServiceEvent(MultipartUploadsEvent.newIgnoredErrorsEvent(threadWatcher, ignoredErrors, uniqueOperationId));
            }
        }.run();
        return success[0];
    }

    private class MultipartUploadObjectRunnable
    extends ThreadedStorageService.AbstractRunnable {
        private MultipartUpload multipartUpload = null;
        private Integer partNumber = null;
        private S3Object object = null;
        private InterruptableInputStream interruptableInputStream = null;
        private BytesProgressWatcher progressMonitor = null;
        private Object result = null;

        public MultipartUploadObjectRunnable(MultipartUpload multipartUpload, Integer partNumber, S3Object object, BytesProgressWatcher progressMonitor) {
            this.multipartUpload = multipartUpload;
            this.partNumber = partNumber;
            this.object = object;
            this.progressMonitor = progressMonitor;
        }

        public void run() {
            try {
                if (this.object.getDataInputStream() != null) {
                    this.interruptableInputStream = new InterruptableInputStream(this.object.getDataInputStream());
                    ProgressMonitoredInputStream pmInputStream = new ProgressMonitoredInputStream(this.interruptableInputStream, this.progressMonitor);
                    this.object.setDataInputStream(pmInputStream);
                }
                ((S3Service)ThreadedS3Service.this.storageService).multipartUploadPart(this.multipartUpload, this.partNumber, this.object);
                this.result = this.object;
            }
            catch (ServiceException e) {
                this.result = e;
            }
        }

        public Object getResult() {
            return this.result;
        }

        public void forceInterruptCalled() {
            if (this.interruptableInputStream != null) {
                this.interruptableInputStream.interrupt();
            }
        }
    }

    private class MultipartCompleteRunnable
    extends ThreadedStorageService.AbstractRunnable {
        private MultipartUpload multipartUpload = null;
        private Object result = null;

        public MultipartCompleteRunnable(MultipartUpload multipartUpload) {
            this.multipartUpload = multipartUpload;
        }

        public void run() {
            try {
                this.result = ((S3Service)ThreadedS3Service.this.storageService).multipartCompleteUpload(this.multipartUpload);
            }
            catch (ServiceException e) {
                this.result = e;
            }
        }

        public Object getResult() {
            return this.result;
        }

        public void forceInterruptCalled() {
        }
    }

    private class MultipartStartRunnable
    extends ThreadedStorageService.AbstractRunnable {
        private String bucketName = null;
        private StorageObject object = null;
        private Object result = null;

        public MultipartStartRunnable(String bucketName, StorageObject object) {
            this.bucketName = bucketName;
            this.object = object;
        }

        public void run() {
            try {
                this.result = ((S3Service)ThreadedS3Service.this.storageService).multipartStartUpload(this.bucketName, this.object.getKey(), this.object.getMetadataMap(), this.object.getAcl(), this.object.getStorageClass());
            }
            catch (ServiceException e) {
                this.result = e;
            }
        }

        public Object getResult() {
            return this.result;
        }

        public void forceInterruptCalled() {
        }
    }
}

