/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.webapp.view;

import java.io.PrintWriter;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.yarn.webapp.View;

@InterfaceAudience.LimitedPrivate(value={"YARN", "MapReduce"})
public abstract class TextView
extends View {
    private final String contentType;

    protected TextView(View.ViewContext ctx, String contentType) {
        super(ctx);
        this.contentType = contentType;
    }

    @Override
    public PrintWriter writer() {
        this.response().setContentType(this.contentType);
        return super.writer();
    }

    public void echo(Object ... args) {
        PrintWriter out = this.writer();
        for (Object s : args) {
            String escapedString = StringEscapeUtils.escapeJavaScript(StringEscapeUtils.escapeHtml(s.toString()));
            out.print(escapedString);
        }
    }

    public void echoWithoutEscapeHtml(Object ... args) {
        PrintWriter out = this.writer();
        for (Object s : args) {
            out.print(s);
        }
    }

    public void puts(Object ... args) {
        this.echo(args);
        this.writer().println();
    }

    public void putWithoutEscapeHtml(Object args) {
        this.echoWithoutEscapeHtml(args);
        this.writer().println();
    }
}

