/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io.retry;

import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.flink.shaded.hadoop2.com.google.common.annotations.VisibleForTesting;
import org.apache.flink.shaded.hadoop2.com.google.common.base.Preconditions;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.io.retry.CallReturn;
import org.apache.hadoop.io.retry.RetryInvocationHandler;
import org.apache.hadoop.ipc.Client;
import org.apache.hadoop.util.Daemon;
import org.apache.hadoop.util.Time;
import org.apache.hadoop.util.concurrent.AsyncGet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class AsyncCallHandler {
    public static final Logger LOG = LoggerFactory.getLogger(AsyncCallHandler.class);
    private static final ThreadLocal<AsyncGet<?, Exception>> LOWER_LAYER_ASYNC_RETURN = new ThreadLocal();
    private static final ThreadLocal<AsyncGet<Object, Throwable>> ASYNC_RETURN = new ThreadLocal();
    private final AsyncCallQueue asyncCalls = new AsyncCallQueue();
    private volatile boolean hasSuccessfulCall = false;

    @InterfaceStability.Unstable
    public static <R, T extends Throwable> AsyncGet<R, T> getAsyncReturn() {
        AsyncGet<Object, Throwable> asyncGet = ASYNC_RETURN.get();
        if (asyncGet != null) {
            ASYNC_RETURN.set(null);
            return asyncGet;
        }
        return AsyncCallHandler.getLowerLayerAsyncReturn();
    }

    @InterfaceStability.Unstable
    public static void setLowerLayerAsyncReturn(AsyncGet<?, Exception> asyncReturn) {
        LOWER_LAYER_ASYNC_RETURN.set(asyncReturn);
    }

    private static AsyncGet<?, Exception> getLowerLayerAsyncReturn() {
        AsyncGet<?, Exception> asyncGet = LOWER_LAYER_ASYNC_RETURN.get();
        Preconditions.checkNotNull(asyncGet);
        LOWER_LAYER_ASYNC_RETURN.set(null);
        return asyncGet;
    }

    AsyncCall newAsyncCall(Method method, Object[] args, boolean isRpc, int callId, RetryInvocationHandler<?> retryInvocationHandler) {
        return new AsyncCall(method, args, isRpc, callId, retryInvocationHandler, this);
    }

    boolean hasSuccessfulCall() {
        return this.hasSuccessfulCall;
    }

    private void initAsyncCall(AsyncCall asyncCall, final AsyncValue<CallReturn> asyncCallReturn) {
        this.asyncCalls.addCall(asyncCall);
        AsyncGet<Object, Throwable> asyncGet = new AsyncGet<Object, Throwable>(){

            @Override
            public Object get(long timeout, TimeUnit unit) throws Throwable {
                CallReturn c = (CallReturn)asyncCallReturn.waitAsyncValue(timeout, unit);
                Object r = c.getReturnValue();
                AsyncCallHandler.this.hasSuccessfulCall = true;
                return r;
            }

            @Override
            public boolean isDone() {
                return asyncCallReturn.isDone();
            }
        };
        ASYNC_RETURN.set(asyncGet);
    }

    @VisibleForTesting
    public static long getGracePeriod() {
        return 3000L;
    }

    static class AsyncCall
    extends RetryInvocationHandler.Call {
        private final AsyncCallHandler asyncCallHandler;
        private final AsyncValue<CallReturn> asyncCallReturn = new AsyncValue();
        private AsyncGet<?, Exception> lowerLayerAsyncGet;

        AsyncCall(Method method, Object[] args, boolean isRpc, int callId, RetryInvocationHandler<?> retryInvocationHandler, AsyncCallHandler asyncCallHandler) {
            super(method, args, isRpc, callId, retryInvocationHandler);
            this.asyncCallHandler = asyncCallHandler;
        }

        boolean isDone() {
            CallReturn r = this.invokeOnce();
            LOG.debug("#{}: {}", (Object)this.getCallId(), (Object)r.getState());
            switch (r.getState()) {
                case RETURNED: 
                case EXCEPTION: {
                    this.asyncCallReturn.set(r);
                    return true;
                }
                case RETRY: {
                    this.invokeOnce();
                    break;
                }
                case WAIT_RETRY: 
                case ASYNC_CALL_IN_PROGRESS: 
                case ASYNC_INVOKED: {
                    break;
                }
                default: {
                    Preconditions.checkState(false);
                }
            }
            return false;
        }

        @Override
        CallReturn processWaitTimeAndRetryInfo() {
            Long waitTime = this.getWaitTime(Time.monotonicNow());
            LOG.trace("#{} processRetryInfo: waitTime={}", (Object)this.getCallId(), (Object)waitTime);
            if (waitTime != null && waitTime > 0L) {
                return CallReturn.WAIT_RETRY;
            }
            this.processRetryInfo();
            return CallReturn.RETRY;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        CallReturn invoke() throws Throwable {
            LOG.debug("{}.invoke {}", (Object)this.getClass().getSimpleName(), (Object)this);
            if (this.lowerLayerAsyncGet != null) {
                boolean isDone = this.lowerLayerAsyncGet.isDone();
                LOG.trace("#{} invoke: lowerLayerAsyncGet.isDone()? {}", (Object)this.getCallId(), (Object)isDone);
                if (!isDone) {
                    return CallReturn.ASYNC_CALL_IN_PROGRESS;
                }
                try {
                    CallReturn callReturn = new CallReturn(this.lowerLayerAsyncGet.get(0L, TimeUnit.SECONDS));
                    return callReturn;
                }
                finally {
                    this.lowerLayerAsyncGet = null;
                }
            }
            LOG.trace("#{} invoke: ASYNC_INVOKED", (Object)this.getCallId());
            boolean mode = Client.isAsynchronousMode();
            try {
                Client.setAsynchronousMode(true);
                Object r = this.invokeMethod();
                Preconditions.checkState(r == null);
                this.lowerLayerAsyncGet = AsyncCallHandler.getLowerLayerAsyncReturn();
                if (this.getCounters().isZeros()) {
                    LOG.trace("#{} invoke: initAsyncCall", (Object)this.getCallId());
                    this.asyncCallHandler.initAsyncCall(this, this.asyncCallReturn);
                }
                CallReturn callReturn = CallReturn.ASYNC_INVOKED;
                return callReturn;
            }
            finally {
                Client.setAsynchronousMode(mode);
            }
        }
    }

    static class AsyncValue<V> {
        private V value;

        AsyncValue() {
        }

        synchronized V waitAsyncValue(long timeout, TimeUnit unit) throws InterruptedException, TimeoutException {
            if (this.value != null) {
                return this.value;
            }
            AsyncGet.Util.wait(this, timeout, unit);
            if (this.value != null) {
                return this.value;
            }
            throw new TimeoutException("waitCallReturn timed out " + timeout + " " + (Object)((Object)unit));
        }

        synchronized void set(V v) {
            Preconditions.checkNotNull(v);
            Preconditions.checkState(this.value == null);
            this.value = v;
            this.notify();
        }

        synchronized boolean isDone() {
            return this.value != null;
        }
    }

    class AsyncCallQueue {
        private final ConcurrentQueue<AsyncCall> queue = new ConcurrentQueue();
        private final Processor processor = new Processor();

        AsyncCallQueue() {
        }

        void addCall(AsyncCall call) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("add " + call);
            }
            this.queue.offer(call);
            this.processor.tryStart();
        }

        long checkCalls() {
            long startTime = Time.monotonicNow();
            long minWaitTime = 100L;
            Iterator<AsyncCall> i = this.queue.iterator();
            while (i.hasNext()) {
                AsyncCall c = i.next();
                if (c.isDone()) {
                    i.remove();
                    this.queue.checkEmpty();
                    continue;
                }
                Long waitTime = c.getWaitTime(startTime);
                if (waitTime == null || waitTime <= 0L || waitTime >= minWaitTime) continue;
                minWaitTime = waitTime;
            }
            return minWaitTime;
        }

        private class Processor {
            static final long GRACE_PERIOD = 3000L;
            static final long MAX_WAIT_PERIOD = 100L;
            private final AtomicReference<Thread> running = new AtomicReference();

            private Processor() {
            }

            boolean isRunning(Daemon d) {
                return d == this.running.get();
            }

            void tryStart() {
                Thread current = Thread.currentThread();
                if (this.running.compareAndSet(null, current)) {
                    Daemon daemon = new Daemon(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            while (Processor.this.isRunning(this)) {
                                long waitTime = AsyncCallQueue.this.checkCalls();
                                Processor.this.tryStop(this);
                                try {
                                    AsyncCallHandler asyncCallHandler = AsyncCallHandler.this;
                                    synchronized (asyncCallHandler) {
                                        AsyncCallHandler.this.wait(waitTime);
                                    }
                                }
                                catch (InterruptedException e) {
                                    Processor.this.kill(this);
                                }
                            }
                        }
                    };
                    boolean set = this.running.compareAndSet(current, daemon);
                    Preconditions.checkState(set);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Starting AsyncCallQueue.Processor " + daemon);
                    }
                    daemon.start();
                }
            }

            void tryStop(Daemon d) {
                if (AsyncCallQueue.this.queue.isEmpty(3000L)) {
                    this.kill(d);
                }
            }

            void kill(Daemon d) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Killing " + d);
                }
                boolean set = this.running.compareAndSet(d, null);
                Preconditions.checkState(set);
            }
        }
    }

    static class ConcurrentQueue<T> {
        private final Queue<T> queue = new ConcurrentLinkedQueue<T>();
        private final AtomicLong emptyStartTime = new AtomicLong(Time.monotonicNow());

        ConcurrentQueue() {
        }

        Iterator<T> iterator() {
            return this.queue.iterator();
        }

        boolean isEmpty(long time) {
            return Time.monotonicNow() - this.emptyStartTime.get() > time && this.queue.isEmpty();
        }

        void offer(T c) {
            boolean added = this.queue.offer(c);
            Preconditions.checkState(added);
        }

        void checkEmpty() {
            if (this.queue.isEmpty()) {
                this.emptyStartTime.set(Time.monotonicNow());
            }
        }
    }
}

