/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.shaded.hadoop2.org.jboss.netty.util.internal;

import java.util.ArrayList;
import java.util.regex.Pattern;
import org.apache.flink.shaded.hadoop2.org.jboss.netty.util.DebugUtil;

public final class StackTraceSimplifier {
    private static final boolean SIMPLIFY_STACK_TRACE = !DebugUtil.isDebugEnabled();
    private static final Pattern EXCLUDED_STACK_TRACE = Pattern.compile("^org\\.jboss\\.netty\\.(util\\.(ThreadRenamingRunnable|internal\\.DeadLockProofWorker)|channel\\.(SimpleChannel(Upstream|Downstream)?Handler|(Default|Static)ChannelPipeline.*))(\\$.*)?$");

    public static void simplify(Throwable e) {
        StackTraceElement[] trace;
        if (!SIMPLIFY_STACK_TRACE) {
            return;
        }
        if (e.getCause() != null) {
            StackTraceSimplifier.simplify(e.getCause());
        }
        if ((trace = e.getStackTrace()) == null || trace.length == 0) {
            return;
        }
        if (EXCLUDED_STACK_TRACE.matcher(trace[0].getClassName()).matches()) {
            return;
        }
        ArrayList<StackTraceElement> simpleTrace = new ArrayList<StackTraceElement>(trace.length);
        simpleTrace.add(trace[0]);
        for (int i = 1; i < trace.length; ++i) {
            if (EXCLUDED_STACK_TRACE.matcher(trace[i].getClassName()).matches()) continue;
            simpleTrace.add(trace[i]);
        }
        e.setStackTrace(simpleTrace.toArray(new StackTraceElement[simpleTrace.size()]));
    }

    private StackTraceSimplifier() {
    }
}

