/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.shaded.hadoop2.org.jboss.netty.handler.codec.spdy;

import org.apache.flink.shaded.hadoop2.org.jboss.netty.buffer.ChannelBuffer;
import org.apache.flink.shaded.hadoop2.org.jboss.netty.handler.codec.compression.CompressionException;
import org.apache.flink.shaded.hadoop2.org.jboss.netty.handler.codec.spdy.SpdyCodecUtil;
import org.apache.flink.shaded.hadoop2.org.jboss.netty.handler.codec.spdy.SpdyHeaderBlockCompressor;
import org.apache.flink.shaded.hadoop2.org.jboss.netty.util.internal.jzlib.JZlib;
import org.apache.flink.shaded.hadoop2.org.jboss.netty.util.internal.jzlib.ZStream;

class SpdyHeaderBlockJZlibCompressor
extends SpdyHeaderBlockCompressor {
    private final ZStream z = new ZStream();

    public SpdyHeaderBlockJZlibCompressor(int version, int compressionLevel, int windowBits, int memLevel) {
        if (version < 2 || version > 3) {
            throw new IllegalArgumentException("unsupported version: " + version);
        }
        if (compressionLevel < 0 || compressionLevel > 9) {
            throw new IllegalArgumentException("compressionLevel: " + compressionLevel + " (expected: 0-9)");
        }
        if (windowBits < 9 || windowBits > 15) {
            throw new IllegalArgumentException("windowBits: " + windowBits + " (expected: 9-15)");
        }
        if (memLevel < 1 || memLevel > 9) {
            throw new IllegalArgumentException("memLevel: " + memLevel + " (expected: 1-9)");
        }
        int resultCode = this.z.deflateInit(compressionLevel, windowBits, memLevel, JZlib.W_ZLIB);
        if (resultCode != 0) {
            throw new CompressionException("failed to initialize an SPDY header block deflater: " + resultCode);
        }
        resultCode = version < 3 ? this.z.deflateSetDictionary(SpdyCodecUtil.SPDY2_DICT, SpdyCodecUtil.SPDY2_DICT.length) : this.z.deflateSetDictionary(SpdyCodecUtil.SPDY_DICT, SpdyCodecUtil.SPDY_DICT.length);
        if (resultCode != 0) {
            throw new CompressionException("failed to set the SPDY dictionary: " + resultCode);
        }
    }

    public void setInput(ChannelBuffer decompressed) {
        byte[] in = new byte[decompressed.readableBytes()];
        decompressed.readBytes(in);
        this.z.next_in = in;
        this.z.next_in_index = 0;
        this.z.avail_in = in.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void encode(ChannelBuffer compressed) {
        try {
            byte[] out = new byte[(int)Math.ceil((double)this.z.next_in.length * 1.001) + 12];
            this.z.next_out = out;
            this.z.next_out_index = 0;
            this.z.avail_out = out.length;
            int resultCode = this.z.deflate(2);
            if (resultCode != 0) {
                throw new CompressionException("compression failure: " + resultCode);
            }
            if (this.z.next_out_index != 0) {
                compressed.writeBytes(out, 0, this.z.next_out_index);
            }
            Object var5_4 = null;
            this.z.next_in = null;
            this.z.next_out = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.z.next_in = null;
            this.z.next_out = null;
            throw throwable;
        }
    }

    public void end() {
        this.z.deflateEnd();
        this.z.next_in = null;
        this.z.next_out = null;
    }
}

