/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.health;

import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.health.CompositeReactiveHealthIndicator;
import org.springframework.boot.actuate.health.DefaultReactiveHealthIndicatorRegistry;
import org.springframework.boot.actuate.health.HealthAggregator;
import org.springframework.boot.actuate.health.ReactiveHealthIndicator;
import org.springframework.boot.actuate.health.ReactiveHealthIndicatorRegistry;
import org.springframework.core.ResolvableType;

public abstract class CompositeReactiveHealthIndicatorConfiguration<H extends ReactiveHealthIndicator, S> {
    @Autowired
    private HealthAggregator healthAggregator;

    protected ReactiveHealthIndicator createHealthIndicator(Map<String, S> beans) {
        if (beans.size() == 1) {
            return this.createHealthIndicator(beans.values().iterator().next());
        }
        DefaultReactiveHealthIndicatorRegistry registry = new DefaultReactiveHealthIndicatorRegistry();
        beans.forEach((arg_0, arg_1) -> this.lambda$createHealthIndicator$0((ReactiveHealthIndicatorRegistry)registry, arg_0, arg_1));
        return new CompositeReactiveHealthIndicator(this.healthAggregator, (ReactiveHealthIndicatorRegistry)registry);
    }

    protected H createHealthIndicator(S source) {
        Class[] generics = ResolvableType.forClass(CompositeReactiveHealthIndicatorConfiguration.class, this.getClass()).resolveGenerics();
        Class indicatorClass = generics[0];
        Class sourceClass = generics[1];
        try {
            return (H)((ReactiveHealthIndicator)indicatorClass.getConstructor(sourceClass).newInstance(source));
        }
        catch (Exception ex) {
            throw new IllegalStateException("Unable to create indicator " + indicatorClass + " for source " + sourceClass, ex);
        }
    }

    private /* synthetic */ void lambda$createHealthIndicator$0(ReactiveHealthIndicatorRegistry registry, String name, Object source) {
        registry.register(name, this.createHealthIndicator(source));
    }
}

