/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph;

import org.apache.commons.lang3.StringUtils;
import org.apache.hugegraph.util.Ex;
import org.mybatis.spring.annotation.MapperScan;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.boot.web.servlet.support.SpringBootServletInitializer;
import org.springframework.scheduling.annotation.EnableScheduling;

@SpringBootApplication
@EnableScheduling
@MapperScan(value={"org.apache.hugegraph.mapper"})
public class HugeGraphHubble
extends SpringBootServletInitializer {
    public static void main(String[] args) {
        HugeGraphHubble.initEnv();
        SpringApplication.run(HugeGraphHubble.class, (String[])args);
    }

    public static void initEnv() {
        String hubbleHomePath = System.getProperty("hubble.home.path");
        Ex.check(StringUtils.isNotEmpty((CharSequence)hubbleHomePath), "The system property 'hubble.home.path' must be set", new Object[0]);
        String loaderHomePath = System.getProperty("loader.home.path");
        if (StringUtils.isEmpty((CharSequence)loaderHomePath)) {
            System.setProperty("loader.home.path", hubbleHomePath);
        }
    }

    protected SpringApplicationBuilder configure(SpringApplicationBuilder builder) {
        return builder.sources(new Class[]{((Object)((Object)this)).getClass()});
    }
}

