/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.marshal;

import java.nio.ByteBuffer;
import org.apache.cassandra.cql3.CQL3Type;
import org.apache.cassandra.cql3.Constants;
import org.apache.cassandra.cql3.Term;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.NumberType;
import org.apache.cassandra.db.marshal.ValueAccessor;
import org.apache.cassandra.serializers.DoubleSerializer;
import org.apache.cassandra.serializers.MarshalException;
import org.apache.cassandra.serializers.TypeSerializer;
import org.apache.cassandra.transport.ProtocolVersion;
import org.apache.cassandra.utils.ByteBufferUtil;

public class DoubleType
extends NumberType<Double> {
    public static final DoubleType instance = new DoubleType();

    DoubleType() {
        super(AbstractType.ComparisonType.CUSTOM);
    }

    @Override
    public boolean isEmptyValueMeaningless() {
        return true;
    }

    @Override
    public boolean isFloatingPoint() {
        return true;
    }

    @Override
    public <VL, VR> int compareCustom(VL left, ValueAccessor<VL> accessorL, VR right, ValueAccessor<VR> accessorR) {
        return DoubleType.compareComposed(left, accessorL, right, accessorR, this);
    }

    @Override
    public ByteBuffer fromString(String source) throws MarshalException {
        if (source.isEmpty()) {
            return ByteBufferUtil.EMPTY_BYTE_BUFFER;
        }
        try {
            return this.decompose(Double.valueOf(source));
        }
        catch (NumberFormatException e1) {
            throw new MarshalException(String.format("Unable to make double from '%s'", source), e1);
        }
    }

    @Override
    public Term fromJSONObject(Object parsed) throws MarshalException {
        try {
            if (parsed instanceof String) {
                return new Constants.Value(this.fromString((String)parsed));
            }
            return new Constants.Value(this.getSerializer().serialize(((Number)parsed).doubleValue()));
        }
        catch (ClassCastException exc) {
            throw new MarshalException(String.format("Expected a double value, but got a %s: %s", parsed.getClass().getSimpleName(), parsed));
        }
    }

    @Override
    public String toJSONString(ByteBuffer buffer, ProtocolVersion protocolVersion) {
        Double value = this.getSerializer().deserialize(buffer);
        if (value == null) {
            return "\"\"";
        }
        if (value.isNaN() || value.isInfinite()) {
            return "null";
        }
        return value.toString();
    }

    @Override
    public CQL3Type asCQL3Type() {
        return CQL3Type.Native.DOUBLE;
    }

    @Override
    public TypeSerializer<Double> getSerializer() {
        return DoubleSerializer.instance;
    }

    @Override
    public int valueLengthIfFixed() {
        return 8;
    }

    @Override
    protected int toInt(ByteBuffer value) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected float toFloat(ByteBuffer value) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected long toLong(ByteBuffer value) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected double toDouble(ByteBuffer value) {
        return ByteBufferUtil.toDouble(value);
    }

    @Override
    public ByteBuffer add(NumberType<?> leftType, ByteBuffer left, NumberType<?> rightType, ByteBuffer right) {
        return ByteBufferUtil.bytes(leftType.toDouble(left) + rightType.toDouble(right));
    }

    @Override
    public ByteBuffer substract(NumberType<?> leftType, ByteBuffer left, NumberType<?> rightType, ByteBuffer right) {
        return ByteBufferUtil.bytes(leftType.toDouble(left) - rightType.toDouble(right));
    }

    @Override
    public ByteBuffer multiply(NumberType<?> leftType, ByteBuffer left, NumberType<?> rightType, ByteBuffer right) {
        return ByteBufferUtil.bytes(leftType.toDouble(left) * rightType.toDouble(right));
    }

    @Override
    public ByteBuffer divide(NumberType<?> leftType, ByteBuffer left, NumberType<?> rightType, ByteBuffer right) {
        return ByteBufferUtil.bytes(leftType.toDouble(left) / rightType.toDouble(right));
    }

    @Override
    public ByteBuffer mod(NumberType<?> leftType, ByteBuffer left, NumberType<?> rightType, ByteBuffer right) {
        return ByteBufferUtil.bytes(leftType.toDouble(left) % rightType.toDouble(right));
    }

    @Override
    public ByteBuffer negate(ByteBuffer input) {
        return ByteBufferUtil.bytes(-this.toDouble(input));
    }
}

