/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.structure;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.hugegraph.HugeException;
import org.apache.hugegraph.HugeGraph;
import org.apache.hugegraph.backend.id.EdgeId;
import org.apache.hugegraph.backend.id.Id;
import org.apache.hugegraph.backend.query.ConditionQuery;
import org.apache.hugegraph.backend.query.QueryResults;
import org.apache.hugegraph.backend.tx.GraphTransaction;
import org.apache.hugegraph.perf.PerfUtil;
import org.apache.hugegraph.schema.EdgeLabel;
import org.apache.hugegraph.schema.PropertyKey;
import org.apache.hugegraph.schema.VertexLabel;
import org.apache.hugegraph.structure.HugeEdgeProperty;
import org.apache.hugegraph.structure.HugeElement;
import org.apache.hugegraph.structure.HugeProperty;
import org.apache.hugegraph.structure.HugeVertex;
import org.apache.hugegraph.type.HugeType;
import org.apache.hugegraph.type.define.Cardinality;
import org.apache.hugegraph.type.define.Directions;
import org.apache.hugegraph.type.define.HugeKeys;
import org.apache.hugegraph.util.E;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Property;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;
import org.apache.tinkerpop.gremlin.structure.util.empty.EmptyProperty;

public class HugeEdge
extends HugeElement
implements Edge,
Cloneable {
    private Id id;
    private final EdgeLabel label;
    private String name;
    private HugeVertex sourceVertex;
    private HugeVertex targetVertex;
    private boolean isOutEdge;

    public HugeEdge(HugeVertex owner, Id id, EdgeLabel label, HugeVertex other) {
        this(owner.graph(), id, label);
        this.fresh(true);
        this.vertices(owner, other);
    }

    public HugeEdge(HugeGraph graph, Id id, EdgeLabel label) {
        super(graph);
        E.checkArgumentNotNull((Object)label, (String)"Edge label can't be null", (Object[])new Object[0]);
        this.label = label;
        this.id = id;
        this.name = null;
        this.sourceVertex = null;
        this.targetVertex = null;
        this.isOutEdge = true;
    }

    @Override
    public HugeType type() {
        return this.isOutEdge ? HugeType.EDGE_OUT : HugeType.EDGE_IN;
    }

    @Override
    public EdgeId id() {
        return (EdgeId)this.id;
    }

    @Override
    public EdgeLabel schemaLabel() {
        assert (this.graph().sameAs(this.label.graph()));
        return this.label;
    }

    @Override
    public String name() {
        if (this.name == null) {
            List<Object> sortValues = this.sortValues();
            this.name = sortValues.isEmpty() ? "" : ConditionQuery.concatValues(sortValues);
        }
        return this.name;
    }

    public void name(String name) {
        this.name = name;
    }

    public String label() {
        return this.label.name();
    }

    public boolean selfLoop() {
        return this.sourceVertex != null && this.sourceVertex == this.targetVertex;
    }

    public Directions direction() {
        return this.isOutEdge ? Directions.OUT : Directions.IN;
    }

    public boolean matchDirection(Directions direction) {
        if (direction == Directions.BOTH || this.selfLoop()) {
            return true;
        }
        return this.isDirection(direction);
    }

    public boolean isDirection(Directions direction) {
        return this.isOutEdge && direction == Directions.OUT || !this.isOutEdge && direction == Directions.IN;
    }

    @PerfUtil.Watched(prefix="edge")
    public void assignId() {
        this.id = new EdgeId(this.ownerVertex(), this.direction(), this.schemaLabel().id(), this.name(), this.otherVertex());
        if (this.fresh()) {
            int len = this.id.length();
            E.checkArgument((len <= 32768 ? 1 : 0) != 0, (String)"The max length of edge id is %s, but got %s {%s}", (Object[])new Object[]{32768, len, this.id});
        }
    }

    @PerfUtil.Watched(prefix="edge")
    public EdgeId idWithDirection() {
        return ((EdgeId)this.id).directed(true);
    }

    @PerfUtil.Watched(prefix="edge")
    protected List<Object> sortValues() {
        List<Id> sortKeys = this.schemaLabel().sortKeys();
        if (sortKeys.isEmpty()) {
            return ImmutableList.of();
        }
        ArrayList<Object> propValues = new ArrayList<Object>(sortKeys.size());
        for (Id sk : sortKeys) {
            HugeProperty property = this.getProperty(sk);
            E.checkState((property != null ? 1 : 0) != 0, (String)"The value of sort key '%s' can't be null", (Object[])new Object[]{sk});
            Object propValue = property.serialValue(true);
            if ("".equals(propValue)) {
                propValue = ConditionQuery.INDEX_VALUE_EMPTY;
            }
            propValues.add(propValue);
        }
        return propValues;
    }

    @PerfUtil.Watched(prefix="edge")
    public void remove() {
        this.removed(true);
        this.sourceVertex.removeEdge(this);
        this.targetVertex.removeEdge(this);
        GraphTransaction tx = this.tx();
        if (tx != null) {
            assert (this.fresh());
            tx.removeEdge(this);
        } else {
            this.graph().removeEdge(this);
        }
    }

    public <V> Property<V> property(String key, V value) {
        PropertyKey propertyKey = this.graph().propertyKey(key);
        E.checkArgument((boolean)this.label.properties().contains(propertyKey.id()), (String)"Invalid property '%s' for edge label '%s'", (Object[])new Object[]{key, this.label()});
        if (value == null) {
            this.removeProperty(propertyKey.id());
            return EmptyProperty.instance();
        }
        if (this.schemaLabel().sortKeys().contains(propertyKey.id())) {
            E.checkArgument((!this.hasProperty(propertyKey.id()) ? 1 : 0) != 0, (String)"Can't update sort key: '%s'", (Object[])new Object[]{key});
        }
        return this.addProperty(propertyKey, value, !this.fresh());
    }

    @Override
    protected GraphTransaction tx() {
        if (this.ownerVertex() == null || !this.fresh()) {
            return null;
        }
        return this.ownerVertex().tx();
    }

    @PerfUtil.Watched(prefix="edge")
    protected <V> HugeEdgeProperty<V> newProperty(PropertyKey pkey, V val) {
        return new HugeEdgeProperty<V>(this, pkey, val);
    }

    @Override
    @PerfUtil.Watched(prefix="edge")
    protected <V> void onUpdateProperty(Cardinality cardinality, HugeProperty<V> prop) {
        if (prop != null) {
            assert (prop instanceof HugeEdgeProperty);
            HugeEdgeProperty edgeProp = (HugeEdgeProperty)prop;
            GraphTransaction tx = this.tx();
            if (tx != null) {
                assert (this.fresh());
                tx.addEdgeProperty(edgeProp);
            } else {
                this.graph().addEdgeProperty(edgeProp);
            }
        }
    }

    @Override
    @PerfUtil.Watched(prefix="edge")
    protected boolean ensureFilledProperties(boolean throwIfNotExist) {
        if (this.isPropLoaded()) {
            this.updateToDefaultValueIfNone();
            return true;
        }
        if (this.schemaLabel().properties().isEmpty()) {
            this.propLoaded();
            return true;
        }
        Iterator<Edge> edges = this.graph().edges(this.id());
        Edge edge = QueryResults.one(edges);
        if (edge == null && !throwIfNotExist) {
            return false;
        }
        E.checkState((edge != null ? 1 : 0) != 0, (String)"Edge '%s' does not exist", (Object[])new Object[]{this.id});
        this.copyProperties((HugeEdge)edge);
        this.updateToDefaultValueIfNone();
        return true;
    }

    @PerfUtil.Watched(prefix="edge")
    public <V> Iterator<Property<V>> properties(String ... keys) {
        this.ensureFilledProperties(true);
        int propsCapacity = keys.length == 0 ? this.sizeOfProperties() : keys.length;
        ArrayList props = new ArrayList(propsCapacity);
        if (keys.length == 0) {
            for (HugeProperty<?> prop : this.getProperties()) {
                assert (prop != null);
                props.add(prop);
            }
        } else {
            for (String key : keys) {
                Id pkeyId;
                try {
                    pkeyId = this.graph().propertyKey(key).id();
                }
                catch (IllegalArgumentException ignored) {
                    continue;
                }
                HugeProperty prop = this.getProperty(pkeyId);
                if (prop == null) continue;
                props.add(prop);
            }
        }
        return props.iterator();
    }

    @Override
    public Object sysprop(HugeKeys key) {
        switch (key) {
            case ID: {
                return this.id();
            }
            case OWNER_VERTEX: {
                return this.ownerVertex().id();
            }
            case LABEL: {
                return this.schemaLabel().id();
            }
            case DIRECTION: {
                return this.direction();
            }
            case OTHER_VERTEX: {
                return this.otherVertex().id();
            }
            case SORT_VALUES: {
                return this.name();
            }
            case PROPERTIES: {
                return this.getPropertiesMap();
            }
        }
        E.checkArgument((boolean)false, (String)"Invalid system property '%s' of Edge", (Object[])new Object[]{key});
        return null;
    }

    public Iterator<Vertex> vertices(Direction direction) {
        ArrayList<HugeVertex> vertices = new ArrayList<HugeVertex>(2);
        switch (direction) {
            case OUT: {
                vertices.add(this.sourceVertex());
                break;
            }
            case IN: {
                vertices.add(this.targetVertex());
                break;
            }
            case BOTH: {
                vertices.add(this.sourceVertex());
                vertices.add(this.targetVertex());
                break;
            }
            default: {
                throw new AssertionError((Object)("Unsupported direction: " + direction));
            }
        }
        return vertices.iterator();
    }

    public Vertex outVertex() {
        return this.sourceVertex();
    }

    public Vertex inVertex() {
        return this.targetVertex();
    }

    public void vertices(HugeVertex owner, HugeVertex other) {
        Id ownerLabel = owner.schemaLabel().id();
        if (ownerLabel.equals(this.label.sourceLabel())) {
            this.vertices(true, owner, other);
        } else {
            assert (ownerLabel.equals(this.label.targetLabel()));
            this.vertices(false, owner, other);
        }
    }

    public void vertices(boolean outEdge, HugeVertex owner, HugeVertex other) {
        this.isOutEdge = outEdge;
        if (this.isOutEdge) {
            this.sourceVertex = owner;
            this.targetVertex = other;
        } else {
            this.sourceVertex = other;
            this.targetVertex = owner;
        }
    }

    @PerfUtil.Watched
    public HugeEdge switchOwner() {
        HugeEdge edge = this.clone();
        edge.isOutEdge = !edge.isOutEdge;
        edge.id = ((EdgeId)edge.id).switchDirection();
        return edge;
    }

    public HugeEdge switchToOutDirection() {
        if (this.direction() == Directions.IN) {
            return this.switchOwner();
        }
        return this;
    }

    public HugeVertex ownerVertex() {
        return this.isOutEdge ? this.sourceVertex() : this.targetVertex();
    }

    public HugeVertex sourceVertex() {
        this.checkAdjacentVertexExist(this.sourceVertex);
        return this.sourceVertex;
    }

    public void sourceVertex(HugeVertex sourceVertex) {
        this.sourceVertex = sourceVertex;
    }

    public HugeVertex targetVertex() {
        this.checkAdjacentVertexExist(this.targetVertex);
        return this.targetVertex;
    }

    public void targetVertex(HugeVertex targetVertex) {
        this.targetVertex = targetVertex;
    }

    private void checkAdjacentVertexExist(HugeVertex vertex) {
        if (vertex.schemaLabel().undefined() && this.graph().checkAdjacentVertexExist()) {
            throw new HugeException("Vertex '%s' does not exist", vertex.id());
        }
    }

    public boolean belongToLabels(String ... edgeLabels) {
        if (edgeLabels.length == 0) {
            return true;
        }
        for (String label : edgeLabels) {
            if (!label.equals(this.label())) continue;
            return true;
        }
        return false;
    }

    public boolean belongToVertex(HugeVertex vertex) {
        return vertex != null && (vertex.equals(this.sourceVertex) || vertex.equals(this.targetVertex));
    }

    public HugeVertex otherVertex(HugeVertex vertex) {
        if (vertex == this.sourceVertex()) {
            return this.targetVertex();
        }
        E.checkArgument((vertex == this.targetVertex() ? 1 : 0) != 0, (String)"Invalid argument vertex '%s', must be in [%s, %s]", (Object[])new Object[]{vertex, this.sourceVertex(), this.targetVertex()});
        return this.sourceVertex();
    }

    public HugeVertex otherVertex() {
        return this.isOutEdge ? this.targetVertex() : this.sourceVertex();
    }

    public HugeEdge prepareRemoved() {
        HugeEdge edge = this.clone();
        edge.removed(true);
        edge.resetProperties();
        return edge;
    }

    @Override
    public HugeEdge copy() {
        HugeEdge edge = this.clone();
        edge.copyProperties(this);
        return edge;
    }

    protected HugeEdge clone() {
        try {
            return (HugeEdge)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new HugeException("Failed to clone HugeEdge", e);
        }
    }

    public String toString() {
        return StringFactory.edgeString((Edge)this);
    }

    public static final EdgeId getIdValue(Object idValue, boolean returnNullIfError) {
        Id id = HugeEdge.getIdValue(idValue);
        if (id == null || id instanceof EdgeId) {
            return (EdgeId)id;
        }
        return EdgeId.parse(id.asString(), returnNullIfError);
    }

    @PerfUtil.Watched
    public static HugeEdge constructEdge(HugeVertex ownerVertex, boolean isOutEdge, EdgeLabel edgeLabel, String sortValues, Id otherVertexId) {
        VertexLabel otherVertexLabel;
        HugeGraph graph = ownerVertex.graph();
        VertexLabel srcLabel = graph.vertexLabelOrNone(edgeLabel.sourceLabel());
        VertexLabel tgtLabel = graph.vertexLabelOrNone(edgeLabel.targetLabel());
        if (isOutEdge) {
            ownerVertex.correctVertexLabel(srcLabel);
            otherVertexLabel = tgtLabel;
        } else {
            ownerVertex.correctVertexLabel(tgtLabel);
            otherVertexLabel = srcLabel;
        }
        HugeVertex otherVertex = new HugeVertex(graph, otherVertexId, otherVertexLabel);
        ownerVertex.propNotLoaded();
        otherVertex.propNotLoaded();
        HugeEdge edge = new HugeEdge(graph, null, edgeLabel);
        edge.name(sortValues);
        edge.vertices(isOutEdge, ownerVertex, otherVertex);
        edge.assignId();
        if (isOutEdge) {
            ownerVertex.addOutEdge(edge);
            otherVertex.addInEdge(edge.switchOwner());
        } else {
            ownerVertex.addInEdge(edge);
            otherVertex.addOutEdge(edge.switchOwner());
        }
        return edge;
    }
}

