/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.computer.core.network.netty.codec;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import org.apache.hugegraph.computer.core.common.exception.IllegalArgException;
import org.apache.hugegraph.computer.core.network.message.AckMessage;
import org.apache.hugegraph.computer.core.network.message.DataMessage;
import org.apache.hugegraph.computer.core.network.message.FinishMessage;
import org.apache.hugegraph.computer.core.network.message.Message;
import org.apache.hugegraph.computer.core.network.message.MessageType;
import org.apache.hugegraph.computer.core.network.message.PingMessage;
import org.apache.hugegraph.computer.core.network.message.PongMessage;
import org.apache.hugegraph.computer.core.network.message.StartMessage;

@ChannelHandler.Sharable
public class MessageDecoder
extends ChannelInboundHandlerAdapter {
    public static final MessageDecoder INSTANCE_FILE_REGION = new MessageDecoder(true);
    public static final MessageDecoder INSTANCE_MEMORY_BUFFER = new MessageDecoder(false);
    private final boolean fileRegionMode;

    private MessageDecoder(boolean fileRegionMode) {
        this.fileRegionMode = fileRegionMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        Message message;
        ByteBuf buf = (ByteBuf)msg;
        try {
            MessageType msgType = MessageType.decode(buf);
            message = this.decode(ctx, msgType, buf);
            if (message == null) {
                return;
            }
        }
        finally {
            buf.release();
        }
        ctx.fireChannelRead((Object)message);
    }

    private Message decode(ChannelHandlerContext ctx, MessageType msgType, ByteBuf in) {
        if (msgType.category() == MessageType.Category.DATA) {
            if (this.fileRegionMode) {
                return DataMessage.parseWithFileRegion(msgType, in);
            }
            return DataMessage.parseWithMemoryBuffer(msgType, in);
        }
        switch (msgType) {
            case START: {
                return StartMessage.parseFrom(in);
            }
            case ACK: {
                return AckMessage.parseFrom(in);
            }
            case FINISH: {
                return FinishMessage.parseFrom(in);
            }
            case PING: {
                return PingMessage.parseFrom(in);
            }
            case PONG: {
                return PongMessage.parseFrom(in);
            }
        }
        throw new IllegalArgException("Can't decode message type: %s", new Object[]{msgType});
    }
}

