/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.computer.core.compute;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import org.apache.hugegraph.computer.core.common.ComputerContext;
import org.apache.hugegraph.computer.core.common.exception.ComputerException;
import org.apache.hugegraph.computer.core.compute.FileGraphPartition;
import org.apache.hugegraph.computer.core.config.ComputerOptions;
import org.apache.hugegraph.computer.core.config.Config;
import org.apache.hugegraph.computer.core.graph.partition.PartitionStat;
import org.apache.hugegraph.computer.core.manager.Managers;
import org.apache.hugegraph.computer.core.network.message.MessageType;
import org.apache.hugegraph.computer.core.receiver.MessageRecvManager;
import org.apache.hugegraph.computer.core.receiver.MessageStat;
import org.apache.hugegraph.computer.core.sender.MessageSendManager;
import org.apache.hugegraph.computer.core.sort.flusher.PeekableIterator;
import org.apache.hugegraph.computer.core.store.entry.KvEntry;
import org.apache.hugegraph.computer.core.util.Consumers;
import org.apache.hugegraph.computer.core.worker.WorkerContext;
import org.apache.hugegraph.computer.core.worker.WorkerStat;
import org.apache.hugegraph.config.TypedOption;
import org.apache.hugegraph.util.ExecutorUtil;
import org.apache.hugegraph.util.Log;
import org.slf4j.Logger;

public class ComputeManager {
    private static final Logger LOG = Log.logger(ComputeManager.class);
    private static final String PREFIX = "partition-compute-executor-%s";
    private final ComputerContext context;
    private final Managers managers;
    private final Map<Integer, FileGraphPartition> partitions;
    private final MessageRecvManager recvManager;
    private final MessageSendManager sendManager;
    private final ExecutorService computeExecutor;

    public ComputeManager(ComputerContext context, Managers managers) {
        this.context = context;
        this.managers = managers;
        this.partitions = new HashMap<Integer, FileGraphPartition>();
        this.recvManager = (MessageRecvManager)this.managers.get("message_recv");
        this.sendManager = (MessageSendManager)this.managers.get("message_send");
        int computeThreadNum = this.partitionComputeThreadNum(context.config());
        this.computeExecutor = ExecutorUtil.newFixedThreadPool((int)computeThreadNum, (String)PREFIX);
        LOG.info("Created partition compute thread poll, thread num: {}", (Object)computeThreadNum);
    }

    private Integer partitionComputeThreadNum(Config config) {
        return (Integer)config.get((TypedOption)ComputerOptions.PARTITIONS_COMPUTE_THREAD_NUMS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WorkerStat input() {
        WorkerStat workerStat = new WorkerStat();
        this.recvManager.waitReceivedAllMessages();
        Map<Integer, PeekableIterator<KvEntry>> vertices = this.recvManager.vertexPartitions();
        Map<Integer, PeekableIterator<KvEntry>> edges = this.recvManager.edgePartitions();
        for (Map.Entry<Integer, PeekableIterator<KvEntry>> entry : vertices.entrySet()) {
            PartitionStat partitionStat;
            FileGraphPartition part;
            int partition;
            block13: {
                partition = entry.getKey();
                PeekableIterator<KvEntry> vertexIter = entry.getValue();
                PeekableIterator<KvEntry> edgesIter = edges.getOrDefault(partition, PeekableIterator.emptyIterator());
                part = new FileGraphPartition(this.context, this.managers, partition);
                partitionStat = null;
                ComputerException inputException = null;
                try {
                    partitionStat = part.input(vertexIter, edgesIter);
                }
                catch (ComputerException e) {
                    inputException = e;
                    return inputException;
                }
                finally {
                    try {
                        vertexIter.close();
                        edgesIter.close();
                    }
                    catch (Exception e) {
                        String message = "Failed to close vertex or edge file iterator";
                        ComputerException closeException = new ComputerException(message, (Throwable)e);
                        if (inputException != null) {
                            inputException.addSuppressed((Throwable)closeException);
                        }
                        throw closeException;
                    }
                    if (inputException == null) break block13;
                    throw inputException;
                }
            }
            workerStat.add(partitionStat);
            this.partitions.put(partition, part);
        }
        return workerStat;
    }

    public void takeRecvedMessages() {
        Map<Integer, PeekableIterator<KvEntry>> messages = this.recvManager.messagePartitions();
        for (FileGraphPartition partition : this.partitions.values()) {
            partition.messages(messages.get(partition.partition()));
        }
    }

    public WorkerStat compute(WorkerContext context, int superstep) {
        this.sendManager.startSend(MessageType.MSG);
        WorkerStat workerStat = new WorkerStat();
        ConcurrentHashMap stats = new ConcurrentHashMap();
        Consumers<FileGraphPartition> consumers = new Consumers<FileGraphPartition>(this.computeExecutor, partition -> {
            PartitionStat stat = partition.compute(context, superstep);
            stats.put(stat.partitionId(), stat);
        });
        consumers.start("partition-compute");
        try {
            for (FileGraphPartition partition2 : this.partitions.values()) {
                consumers.provide(partition2);
            }
            consumers.await();
        }
        catch (Throwable t) {
            throw new ComputerException("An exception occurred when partition parallel compute", t);
        }
        this.sendManager.finishSend(MessageType.MSG);
        Map<Integer, MessageStat> recvStats = this.recvManager.messageStats();
        for (Map.Entry entry : stats.entrySet()) {
            PartitionStat partStat = (PartitionStat)entry.getValue();
            int partitionId = partStat.partitionId();
            MessageStat sendStat = this.sendManager.messageStat(partitionId);
            partStat.mergeSendMessageStat(sendStat);
            MessageStat recvStat = recvStats.get(partitionId);
            if (recvStat != null) {
                partStat.mergeRecvMessageStat(recvStat);
            }
            workerStat.add(partStat);
        }
        return workerStat;
    }

    public void output() {
        for (FileGraphPartition partition : this.partitions.values()) {
            PartitionStat stat = partition.output();
            LOG.info("Output partition {} complete, stat='{}'", (Object)partition.partition(), (Object)stat);
        }
    }

    public void close() {
        this.computeExecutor.shutdown();
    }
}

