/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.loader.direct.loader;

import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import org.apache.hugegraph.loader.builder.EdgeBuilder;
import org.apache.hugegraph.loader.builder.ElementBuilder;
import org.apache.hugegraph.loader.builder.VertexBuilder;
import org.apache.hugegraph.loader.executor.LoadContext;
import org.apache.hugegraph.loader.executor.LoadOptions;
import org.apache.hugegraph.loader.mapping.EdgeMapping;
import org.apache.hugegraph.loader.mapping.InputStruct;
import org.apache.hugegraph.loader.mapping.VertexMapping;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;

public abstract class DirectLoader<T, R>
implements Serializable {
    LoadOptions loadOptions;
    InputStruct struct;

    public DirectLoader(LoadOptions loadOptions, InputStruct struct) {
        this.loadOptions = loadOptions;
        this.struct = struct;
    }

    public final void bulkload(Dataset<Row> ds) {
        JavaPairRDD<T, R> javaPairRDD = this.buildVertexAndEdge(ds);
        String path = this.generateFiles(javaPairRDD);
        this.loadFiles(path);
    }

    protected List<ElementBuilder> getElementBuilders() {
        LoadContext context = new LoadContext(this.loadOptions);
        context.schemaCache().updateAll();
        LinkedList<ElementBuilder> buildersForGraphElement = new LinkedList<ElementBuilder>();
        for (VertexMapping vertexMapping : this.struct.vertices()) {
            buildersForGraphElement.add(new VertexBuilder(context, this.struct, vertexMapping));
        }
        for (EdgeMapping edgeMapping : this.struct.edges()) {
            buildersForGraphElement.add(new EdgeBuilder(context, this.struct, edgeMapping));
        }
        context.close();
        return buildersForGraphElement;
    }

    abstract JavaPairRDD<T, R> buildVertexAndEdge(Dataset<Row> var1);

    abstract String generateFiles(JavaPairRDD<T, R> var1);

    abstract void loadFiles(String var1);
}

