/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.http;

import java.util.ArrayList;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.hadoop.security.http.XFrameOptionsFilter;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

public class TestXFrameOptionsFilter {
    private static final String X_FRAME_OPTIONS = "X-Frame-Options";

    @Test
    public void testDefaultOptionsValue() throws Exception {
        final ArrayList headers = new ArrayList();
        FilterConfig filterConfig = (FilterConfig)Mockito.mock(FilterConfig.class);
        Mockito.when((Object)filterConfig.getInitParameter("xframe-options")).thenReturn(null);
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        HttpServletResponse response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        FilterChain chain = (FilterChain)Mockito.mock(FilterChain.class);
        ((FilterChain)Mockito.doAnswer((Answer)new Answer(){

            public Object answer(InvocationOnMock invocation) throws Throwable {
                Object[] args = invocation.getArguments();
                Assert.assertTrue((String)"header should be visible inside chain and filters.", (boolean)((HttpServletResponse)args[1]).containsHeader(TestXFrameOptionsFilter.X_FRAME_OPTIONS));
                return null;
            }
        }).when((Object)chain)).doFilter((ServletRequest)ArgumentMatchers.any(), (ServletResponse)ArgumentMatchers.any());
        ((HttpServletResponse)Mockito.doAnswer((Answer)new Answer(){

            public Object answer(InvocationOnMock invocation) throws Throwable {
                Object[] args = invocation.getArguments();
                Assert.assertTrue((String)("Options value incorrect should be DENY but is: " + args[1]), (boolean)"DENY".equals(args[1]));
                headers.add((String)args[1]);
                return null;
            }
        }).when((Object)response)).setHeader((String)ArgumentMatchers.any(), (String)ArgumentMatchers.any());
        XFrameOptionsFilter filter = new XFrameOptionsFilter();
        filter.init(filterConfig);
        filter.doFilter((ServletRequest)request, (ServletResponse)response, chain);
        ((AbstractIntegerAssert)Assertions.assertThat((int)headers.size()).withFailMessage("X-Frame-Options count not equal to 1.", new Object[0])).isOne();
    }

    @Test
    public void testCustomOptionsValueAndNoOverrides() throws Exception {
        final ArrayList headers = new ArrayList();
        FilterConfig filterConfig = (FilterConfig)Mockito.mock(FilterConfig.class);
        Mockito.when((Object)filterConfig.getInitParameter("xframe-options")).thenReturn((Object)"SAMEORIGIN");
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        HttpServletResponse response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        FilterChain chain = (FilterChain)Mockito.mock(FilterChain.class);
        ((FilterChain)Mockito.doAnswer((Answer)new Answer(){

            public Object answer(InvocationOnMock invocation) throws Throwable {
                Object[] args = invocation.getArguments();
                HttpServletResponse resp = (HttpServletResponse)args[1];
                Assert.assertTrue((String)"Header should be visible inside chain and filters.", (boolean)resp.containsHeader(TestXFrameOptionsFilter.X_FRAME_OPTIONS));
                Assert.assertTrue((boolean)(resp instanceof XFrameOptionsFilter.XFrameOptionsResponseWrapper));
                resp.setHeader(TestXFrameOptionsFilter.X_FRAME_OPTIONS, "LJM");
                return null;
            }
        }).when((Object)chain)).doFilter((ServletRequest)ArgumentMatchers.any(), (ServletResponse)ArgumentMatchers.any());
        ((HttpServletResponse)Mockito.doAnswer((Answer)new Answer(){

            public Object answer(InvocationOnMock invocation) throws Throwable {
                Object[] args = invocation.getArguments();
                Assert.assertEquals((String)("Options value incorrect should be SAMEORIGIN but is: " + args[1]), (Object)"SAMEORIGIN", (Object)args[1]);
                headers.add((String)args[1]);
                return null;
            }
        }).when((Object)response)).setHeader((String)ArgumentMatchers.any(), (String)ArgumentMatchers.any());
        XFrameOptionsFilter filter = new XFrameOptionsFilter();
        filter.init(filterConfig);
        filter.doFilter((ServletRequest)request, (ServletResponse)response, chain);
        ((AbstractIntegerAssert)Assertions.assertThat((int)headers.size()).withFailMessage("X-Frame-Options count not equal to 1.", new Object[0])).isOne();
        ((ObjectAssert)Assertions.assertThat((Object)headers.toArray()[0]).withFailMessage("X-Frame-Options count not equal to 1.", new Object[0])).isEqualTo((Object)"SAMEORIGIN");
    }
}

