/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ipc;

import com.google.protobuf.RpcController;
import com.google.protobuf.ServiceException;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.TimeoutException;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ipc.ProtobufRpcEngine;
import org.apache.hadoop.ipc.ProtobufRpcEngine2;
import org.apache.hadoop.ipc.ProtocolInfo;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.ipc.RpcServerException;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.ipc.TestRpcBase;
import org.apache.hadoop.ipc.metrics.RpcMetrics;
import org.apache.hadoop.ipc.protobuf.RpcHeaderProtos;
import org.apache.hadoop.ipc.protobuf.TestProtos;
import org.apache.hadoop.ipc.protobuf.TestProtosLegacy;
import org.apache.hadoop.ipc.protobuf.TestRpcServiceProtos;
import org.apache.hadoop.ipc.protobuf.TestRpcServiceProtosLegacy;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.test.MetricsAsserts;
import org.apache.hadoop.thirdparty.protobuf.BlockingService;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TestProtoBufRpc
extends TestRpcBase {
    private static RPC.Server server;
    private static final int SLEEP_DURATION = 1000;
    private boolean testWithLegacy;
    private boolean testWithLegacyFirst;

    public TestProtoBufRpc(Boolean testWithLegacy, Boolean testWithLegacyFirst) {
        this.testWithLegacy = testWithLegacy;
        this.testWithLegacyFirst = testWithLegacyFirst;
    }

    @Parameterized.Parameters
    public static Collection<Object[]> params() {
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        params.add(new Object[]{Boolean.TRUE, Boolean.TRUE});
        params.add(new Object[]{Boolean.TRUE, Boolean.FALSE});
        params.add(new Object[]{Boolean.FALSE, Boolean.FALSE});
        return params;
    }

    @Before
    public void setUp() throws IOException {
        conf = new Configuration();
        conf.setInt("ipc.maximum.data.length", 1024);
        conf.setBoolean("ipc.server.log.slow.rpc", true);
        if (this.testWithLegacy) {
            RPC.setProtocolEngine((Configuration)conf, TestRpcService2Legacy.class, ProtobufRpcEngine.class);
        }
        RPC.setProtocolEngine((Configuration)conf, TestRpcBase.TestRpcService.class, ProtobufRpcEngine2.class);
        RPC.setProtocolEngine((Configuration)conf, TestRpcService2.class, ProtobufRpcEngine2.class);
        TestRpcBase.PBServerImpl serverImpl = new TestRpcBase.PBServerImpl();
        BlockingService service = TestRpcServiceProtos.TestProtobufRpcProto.newReflectiveBlockingService(serverImpl);
        if (this.testWithLegacy && this.testWithLegacyFirst) {
            PBServer2ImplLegacy server2ImplLegacy = new PBServer2ImplLegacy();
            com.google.protobuf.BlockingService legacyService = TestRpcServiceProtosLegacy.TestProtobufRpc2Proto.newReflectiveBlockingService(server2ImplLegacy);
            server = new RPC.Builder(conf).setProtocol(TestRpcService2Legacy.class).setInstance((Object)legacyService).setBindAddress("0.0.0.0").setPort(0).build();
            server.addProtocol(RPC.RpcKind.RPC_PROTOCOL_BUFFER, TestRpcBase.TestRpcService.class, (Object)service);
        } else {
            server = new RPC.Builder(conf).setProtocol(TestRpcBase.TestRpcService.class).setInstance((Object)service).setBindAddress("0.0.0.0").setPort(0).build();
        }
        addr = NetUtils.getConnectAddress((Server)server);
        PBServer2Impl server2Impl = new PBServer2Impl();
        BlockingService service2 = TestRpcServiceProtos.TestProtobufRpc2Proto.newReflectiveBlockingService(server2Impl);
        server.addProtocol(RPC.RpcKind.RPC_PROTOCOL_BUFFER, TestRpcService2.class, (Object)service2);
        if (this.testWithLegacy && !this.testWithLegacyFirst) {
            PBServer2ImplLegacy server2ImplLegacy = new PBServer2ImplLegacy();
            com.google.protobuf.BlockingService legacyService = TestRpcServiceProtosLegacy.TestProtobufRpc2Proto.newReflectiveBlockingService(server2ImplLegacy);
            server.addProtocol(RPC.RpcKind.RPC_PROTOCOL_BUFFER, TestRpcService2Legacy.class, (Object)legacyService);
        }
        server.start();
    }

    @After
    public void tearDown() throws Exception {
        server.stop();
    }

    private TestRpcService2 getClient2() throws IOException {
        return (TestRpcService2)RPC.getProxy(TestRpcService2.class, (long)0L, (InetSocketAddress)addr, (Configuration)conf);
    }

    private TestRpcService2Legacy getClientLegacy() throws IOException {
        return (TestRpcService2Legacy)RPC.getProxy(TestRpcService2Legacy.class, (long)0L, (InetSocketAddress)addr, (Configuration)conf);
    }

    @Test(timeout=5000L)
    public void testProtoBufRpc() throws Exception {
        TestRpcBase.TestRpcService client = TestProtoBufRpc.getClient(addr, conf);
        TestProtoBufRpc.testProtoBufRpc(client);
    }

    public static void testProtoBufRpc(TestRpcBase.TestRpcService client) throws Exception {
        client.ping(null, TestProtoBufRpc.newEmptyRequest());
        TestProtos.EchoRequestProto echoRequest = TestProtos.EchoRequestProto.newBuilder().setMessage("hello").build();
        TestProtos.EchoResponseProto echoResponse = client.echo(null, echoRequest);
        Assertions.assertThat((String)echoResponse.getMessage()).isEqualTo((Object)"hello");
        try {
            client.error(null, TestProtoBufRpc.newEmptyRequest());
            Assert.fail((String)"Expected exception is not thrown");
        }
        catch (org.apache.hadoop.thirdparty.protobuf.ServiceException e) {
            RemoteException re = (RemoteException)e.getCause();
            RpcServerException rse = (RpcServerException)re.unwrapRemoteException(new Class[]{RpcServerException.class});
            Assertions.assertThat((Throwable)rse).isNotNull();
            Assertions.assertThat((Comparable)re.getErrorCode()).isEqualTo((Object)RpcHeaderProtos.RpcResponseHeaderProto.RpcErrorCodeProto.ERROR_RPC_SERVER);
        }
    }

    @Test(timeout=5000L)
    public void testProtoBufRpc2() throws Exception {
        TestRpcService2 client = this.getClient2();
        client.ping2(null, TestProtoBufRpc.newEmptyRequest());
        TestProtos.EchoResponseProto echoResponse = client.echo2(null, TestProtoBufRpc.newEchoRequest("hello"));
        Assertions.assertThat((String)echoResponse.getMessage()).isEqualTo((Object)"hello");
        MetricsRecordBuilder rpcMetrics = MetricsAsserts.getMetrics(server.getRpcMetrics().name());
        MetricsAsserts.assertCounterGt("RpcQueueTimeNumOps", 0L, rpcMetrics);
        MetricsAsserts.assertCounterGt("RpcProcessingTimeNumOps", 0L, rpcMetrics);
        MetricsRecordBuilder rpcDetailedMetrics = MetricsAsserts.getMetrics(server.getRpcDetailedMetrics().name());
        MetricsAsserts.assertCounterGt("Echo2NumOps", 0L, rpcDetailedMetrics);
        if (this.testWithLegacy) {
            this.testProtobufLegacy();
        }
    }

    private void testProtobufLegacy() throws IOException, ServiceException {
        TestRpcService2Legacy client = this.getClientLegacy();
        client.ping2(null, TestProtosLegacy.EmptyRequestProto.newBuilder().build());
        TestProtosLegacy.EchoResponseProto echoResponse = client.echo2(null, TestProtosLegacy.EchoRequestProto.newBuilder().setMessage("hello").build());
        Assertions.assertThat((String)echoResponse.getMessage()).isEqualTo((Object)"hello");
        MetricsRecordBuilder rpcMetrics = MetricsAsserts.getMetrics(server.getRpcMetrics().name());
        MetricsAsserts.assertCounterGt("RpcQueueTimeNumOps", 0L, rpcMetrics);
        MetricsAsserts.assertCounterGt("RpcProcessingTimeNumOps", 0L, rpcMetrics);
        MetricsRecordBuilder rpcDetailedMetrics = MetricsAsserts.getMetrics(server.getRpcDetailedMetrics().name());
        MetricsAsserts.assertCounterGt("Echo2NumOps", 0L, rpcDetailedMetrics);
    }

    @Test(timeout=5000L)
    public void testProtoBufRandomException() throws Exception {
        Assume.assumeFalse((boolean)this.testWithLegacy);
        TestRpcBase.TestRpcService client = TestProtoBufRpc.getClient(addr, conf);
        try {
            client.error2(null, TestProtoBufRpc.newEmptyRequest());
        }
        catch (org.apache.hadoop.thirdparty.protobuf.ServiceException se) {
            Assertions.assertThat((Throwable)se.getCause()).isInstanceOf(RemoteException.class);
            RemoteException re = (RemoteException)se.getCause();
            Assertions.assertThat((String)re.getClassName()).isEqualTo((Object)URISyntaxException.class.getName());
            Assertions.assertThat((String)re.getMessage()).contains(new CharSequence[]{"testException"});
            Assertions.assertThat((Comparable)re.getErrorCode()).isEqualTo((Object)RpcHeaderProtos.RpcResponseHeaderProto.RpcErrorCodeProto.ERROR_APPLICATION);
        }
    }

    @Test(timeout=6000L)
    public void testExtraLongRpc() throws Exception {
        Assume.assumeFalse((boolean)this.testWithLegacy);
        TestRpcService2 client = this.getClient2();
        String shortString = StringUtils.repeat((String)"X", (int)4);
        TestProtos.EchoResponseProto echoResponse = client.echo2(null, TestProtoBufRpc.newEchoRequest(shortString));
        Assertions.assertThat((String)echoResponse.getMessage()).isEqualTo((Object)shortString);
        String longString = StringUtils.repeat((String)"X", (int)4096);
        try {
            client.echo2(null, TestProtoBufRpc.newEchoRequest(longString));
            Assert.fail((String)"expected extra-long RPC to fail");
        }
        catch (org.apache.hadoop.thirdparty.protobuf.ServiceException serviceException) {
            // empty catch block
        }
    }

    @Test(timeout=12000L)
    public void testLogSlowRPC() throws IOException, org.apache.hadoop.thirdparty.protobuf.ServiceException, TimeoutException, InterruptedException {
        Assume.assumeFalse((boolean)this.testWithLegacy);
        server.setLogSlowRPCThresholdTime(1000L);
        TestRpcService2 client = this.getClient2();
        for (int x = 0; x < 10000; ++x) {
            client.ping2(null, TestProtoBufRpc.newEmptyRequest());
            continue;
        }
        RpcMetrics rpcMetrics = server.getRpcMetrics();
        Assertions.assertThat((long)rpcMetrics.getProcessingSampleCount()).isGreaterThan(999L);
        long before = rpcMetrics.getRpcSlowCalls();
        client.sleep(null, TestProtoBufRpc.newSleepRequest(500));
        long after = rpcMetrics.getRpcSlowCalls();
        Assertions.assertThat((long)before).isEqualTo(after);
        client.sleep(null, TestProtoBufRpc.newSleepRequest(3000));
        GenericTestUtils.waitFor(() -> rpcMetrics.getRpcSlowCalls() == before + 1L, 10L, 1000L);
    }

    @Test(timeout=12000L)
    public void testEnsureNoLogIfDisabled() throws IOException, org.apache.hadoop.thirdparty.protobuf.ServiceException {
        Assume.assumeFalse((boolean)this.testWithLegacy);
        server.setLogSlowRPC(false);
        TestRpcService2 client = this.getClient2();
        for (int x = 0; x < 10000; ++x) {
            client.ping2(null, TestProtoBufRpc.newEmptyRequest());
        }
        RpcMetrics rpcMetrics = server.getRpcMetrics();
        Assertions.assertThat((long)rpcMetrics.getProcessingSampleCount()).isGreaterThan(999L);
        long before = rpcMetrics.getRpcSlowCalls();
        client.sleep(null, TestProtoBufRpc.newSleepRequest(1000));
        long after = rpcMetrics.getRpcSlowCalls();
        Assertions.assertThat((long)before).isEqualTo(after);
    }

    public static class PBServer2ImplLegacy
    implements TestRpcService2Legacy {
        @Override
        public TestProtosLegacy.EmptyResponseProto ping2(RpcController unused, TestProtosLegacy.EmptyRequestProto request) throws ServiceException {
            return TestProtosLegacy.EmptyResponseProto.newBuilder().build();
        }

        @Override
        public TestProtosLegacy.EchoResponseProto echo2(RpcController unused, TestProtosLegacy.EchoRequestProto request) throws ServiceException {
            return TestProtosLegacy.EchoResponseProto.newBuilder().setMessage(request.getMessage()).build();
        }

        @Override
        public TestProtosLegacy.SleepResponseProto sleep(RpcController controller, TestProtosLegacy.SleepRequestProto request) throws ServiceException {
            try {
                Thread.sleep(request.getMilliSeconds());
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return TestProtosLegacy.SleepResponseProto.newBuilder().build();
        }
    }

    public static class PBServer2Impl
    implements TestRpcService2 {
        @Override
        public TestProtos.EmptyResponseProto ping2(org.apache.hadoop.thirdparty.protobuf.RpcController unused, TestProtos.EmptyRequestProto request) throws org.apache.hadoop.thirdparty.protobuf.ServiceException {
            return TestProtos.EmptyResponseProto.newBuilder().build();
        }

        @Override
        public TestProtos.EchoResponseProto echo2(org.apache.hadoop.thirdparty.protobuf.RpcController unused, TestProtos.EchoRequestProto request) throws org.apache.hadoop.thirdparty.protobuf.ServiceException {
            return TestProtos.EchoResponseProto.newBuilder().setMessage(request.getMessage()).build();
        }

        @Override
        public TestProtos.SleepResponseProto sleep(org.apache.hadoop.thirdparty.protobuf.RpcController controller, TestProtos.SleepRequestProto request) throws org.apache.hadoop.thirdparty.protobuf.ServiceException {
            try {
                Thread.sleep(request.getMilliSeconds());
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return TestProtos.SleepResponseProto.newBuilder().build();
        }
    }

    @ProtocolInfo(protocolName="testProtoLegacy", protocolVersion=1L)
    public static interface TestRpcService2Legacy
    extends TestRpcServiceProtosLegacy.TestProtobufRpc2Proto.BlockingInterface {
    }

    @ProtocolInfo(protocolName="testProto2", protocolVersion=1L)
    public static interface TestRpcService2
    extends TestRpcServiceProtos.TestProtobufRpc2Proto.BlockingInterface {
    }
}

