/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.lib.servlet;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.lib.service.FileSystemAccess;

@InterfaceAudience.Private
public abstract class FileSystemReleaseFilter
implements Filter {
    private static final ThreadLocal<FileSystem> FILE_SYSTEM_TL = new ThreadLocal();

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        try {
            filterChain.doFilter(servletRequest, servletResponse);
        }
        finally {
            FileSystem fs = FILE_SYSTEM_TL.get();
            if (fs != null) {
                FILE_SYSTEM_TL.remove();
                this.getFileSystemAccess().releaseFileSystem(fs);
            }
        }
    }

    public void destroy() {
    }

    public static void setFileSystem(FileSystem fs) {
        FILE_SYSTEM_TL.set(fs);
    }

    protected abstract FileSystemAccess getFileSystemAccess();
}

