/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a.auth;

import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.s3a.Invoker;
import org.apache.hadoop.fs.s3a.impl.AWSClientConfig;
import org.apache.hadoop.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.retry.RetryPolicy;
import software.amazon.awssdk.http.SdkHttpClient;
import software.amazon.awssdk.http.apache.ApacheHttpClient;
import software.amazon.awssdk.http.apache.ProxyConfiguration;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.sts.StsClient;
import software.amazon.awssdk.services.sts.StsClientBuilder;
import software.amazon.awssdk.services.sts.model.AssumeRoleRequest;
import software.amazon.awssdk.services.sts.model.Credentials;
import software.amazon.awssdk.services.sts.model.GetSessionTokenRequest;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class STSClientFactory {
    private static final Logger LOG = LoggerFactory.getLogger(STSClientFactory.class);

    public static StsClientBuilder builder(Configuration conf, String bucket, AwsCredentialsProvider credentials) throws IOException {
        String endpoint = conf.getTrimmed("fs.s3a.assumed.role.sts.endpoint", "");
        String region = conf.getTrimmed("fs.s3a.assumed.role.sts.endpoint.region", "");
        return STSClientFactory.builder(credentials, conf, endpoint, region, bucket);
    }

    public static StsClientBuilder builder(Configuration conf, String bucket, AwsCredentialsProvider credentials, String stsEndpoint, String stsRegion) throws IOException {
        return STSClientFactory.builder(credentials, conf, stsEndpoint, stsRegion, bucket);
    }

    public static StsClientBuilder builder(AwsCredentialsProvider credentials, Configuration conf, String stsEndpoint, String stsRegion, String bucket) throws IOException {
        StsClientBuilder stsClientBuilder = StsClient.builder();
        Preconditions.checkArgument((credentials != null ? 1 : 0) != 0, (Object)"No credentials");
        ClientOverrideConfiguration.Builder clientOverrideConfigBuilder = AWSClientConfig.createClientConfigBuilder(conf, "STS");
        ApacheHttpClient.Builder httpClientBuilder = AWSClientConfig.createHttpClientBuilder(conf);
        RetryPolicy.Builder retryPolicyBuilder = AWSClientConfig.createRetryPolicyBuilder(conf);
        ProxyConfiguration proxyConfig = AWSClientConfig.createProxyConfiguration(conf, bucket);
        clientOverrideConfigBuilder.retryPolicy(retryPolicyBuilder.build());
        httpClientBuilder.proxyConfiguration(proxyConfig);
        ((StsClientBuilder)((StsClientBuilder)stsClientBuilder.httpClientBuilder((SdkHttpClient.Builder)httpClientBuilder)).overrideConfiguration((ClientOverrideConfiguration)clientOverrideConfigBuilder.build())).credentialsProvider(credentials);
        boolean destIsStandardEndpoint = "sts.amazonaws.com".equals(stsEndpoint);
        if (StringUtils.isNotEmpty((CharSequence)stsEndpoint) && !destIsStandardEndpoint) {
            Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)stsRegion), (String)"STS endpoint is set to %s but no signing region was provided", (Object[])new Object[]{stsEndpoint});
            LOG.debug("STS Endpoint={}; region='{}'", (Object)stsEndpoint, (Object)stsRegion);
            ((StsClientBuilder)stsClientBuilder.endpointOverride(STSClientFactory.getSTSEndpoint(stsEndpoint))).region(Region.of((String)stsRegion));
        } else {
            Preconditions.checkArgument((boolean)StringUtils.isEmpty((CharSequence)stsRegion), (String)"STS signing region set set to %s but no STS endpoint specified", (Object[])new Object[]{stsRegion});
        }
        return stsClientBuilder;
    }

    private static URI getSTSEndpoint(String endpoint) {
        try {
            return new URI("https", endpoint, null, null);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static STSClient createClientConnection(StsClient stsClient, Invoker invoker) {
        return new STSClient(stsClient, invoker);
    }

    public static final class STSClient
    implements Closeable {
        private final StsClient stsClient;
        private final Invoker invoker;

        private STSClient(StsClient stsClient, Invoker invoker) {
            this.stsClient = stsClient;
            this.invoker = invoker;
        }

        @Override
        public void close() throws IOException {
            this.stsClient.close();
        }

        public Credentials requestSessionCredentials(long duration, TimeUnit timeUnit) throws IOException {
            int durationSeconds = (int)timeUnit.toSeconds(duration);
            LOG.debug("Requesting session token of duration {}", (Object)duration);
            GetSessionTokenRequest request = (GetSessionTokenRequest)GetSessionTokenRequest.builder().durationSeconds(Integer.valueOf(durationSeconds)).build();
            return (Credentials)this.invoker.retry("request session credentials", "", true, () -> {
                LOG.info("Requesting Amazon STS Session credentials");
                return this.stsClient.getSessionToken(request).credentials();
            });
        }

        public Credentials requestRole(String roleARN, String sessionName, String policy, long duration, TimeUnit timeUnit) throws IOException {
            LOG.debug("Requesting role {} with duration {}; policy = {}", new Object[]{roleARN, duration, policy});
            AssumeRoleRequest.Builder requestBuilder = AssumeRoleRequest.builder().durationSeconds(Integer.valueOf((int)timeUnit.toSeconds(duration))).roleArn(roleARN).roleSessionName(sessionName);
            if (StringUtils.isNotEmpty((CharSequence)policy)) {
                requestBuilder.policy(policy);
            }
            return (Credentials)this.invoker.retry("request role credentials", "", true, () -> this.stsClient.assumeRole((AssumeRoleRequest)requestBuilder.build()).credentials());
        }
    }
}

