/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.reservation;

import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.authorize.AccessControlList;
import org.apache.hadoop.yarn.api.records.ReservationACL;

public abstract class ReservationSchedulerConfiguration
extends Configuration {
    @InterfaceAudience.Private
    public static final long DEFAULT_RESERVATION_WINDOW = 86400000L;
    @InterfaceAudience.Private
    public static final String DEFAULT_RESERVATION_ADMISSION_POLICY = "org.apache.hadoop.yarn.server.resourcemanager.reservation.CapacityOverTimePolicy";
    @InterfaceAudience.Private
    public static final String DEFAULT_RESERVATION_AGENT_NAME = "org.apache.hadoop.yarn.server.resourcemanager.reservation.planning.AlignedPlannerWithGreedy";
    @InterfaceAudience.Private
    public static final String DEFAULT_RESERVATION_PLANNER_NAME = "org.apache.hadoop.yarn.server.resourcemanager.reservation.planning.SimpleCapacityReplanner";
    @InterfaceAudience.Private
    public static final boolean DEFAULT_RESERVATION_MOVE_ON_EXPIRY = true;
    @InterfaceAudience.Private
    public static final long DEFAULT_RESERVATION_ENFORCEMENT_WINDOW = 3600000L;
    @InterfaceAudience.Private
    public static final boolean DEFAULT_SHOW_RESERVATIONS_AS_QUEUES = false;
    @InterfaceAudience.Private
    public static final float DEFAULT_CAPACITY_OVER_TIME_MULTIPLIER = 1.0f;

    public ReservationSchedulerConfiguration() {
    }

    public ReservationSchedulerConfiguration(Configuration configuration) {
        super(configuration);
    }

    public abstract boolean isReservable(String var1);

    public abstract Map<ReservationACL, AccessControlList> getReservationAcls(String var1);

    public long getReservationWindow(String queue) {
        return 86400000L;
    }

    public float getAverageCapacity(String queue) {
        return 1.0f;
    }

    public float getInstantaneousMaxCapacity(String queue) {
        return 1.0f;
    }

    public String getReservationAdmissionPolicy(String queue) {
        return DEFAULT_RESERVATION_ADMISSION_POLICY;
    }

    public String getReservationAgent(String queue) {
        return DEFAULT_RESERVATION_AGENT_NAME;
    }

    public boolean getShowReservationAsQueues(String queuePath) {
        return false;
    }

    public String getReplanner(String queue) {
        return DEFAULT_RESERVATION_PLANNER_NAME;
    }

    public boolean getMoveOnExpiry(String queue) {
        return true;
    }

    public long getEnforcementWindow(String queue) {
        return 3600000L;
    }
}

