/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.com.nimbusds.jose.crypto;

import java.security.PrivateKey;
import java.util.Collections;
import java.util.Set;
import javax.crypto.SecretKey;
import org.apache.hadoop.shaded.com.nimbusds.jose.CriticalHeaderParamsAware;
import org.apache.hadoop.shaded.com.nimbusds.jose.JOSEException;
import org.apache.hadoop.shaded.com.nimbusds.jose.JWEAlgorithm;
import org.apache.hadoop.shaded.com.nimbusds.jose.JWEDecrypter;
import org.apache.hadoop.shaded.com.nimbusds.jose.JWEDecrypterOption;
import org.apache.hadoop.shaded.com.nimbusds.jose.JWEHeader;
import org.apache.hadoop.shaded.com.nimbusds.jose.crypto.impl.AAD;
import org.apache.hadoop.shaded.com.nimbusds.jose.crypto.impl.AlgorithmSupportMessage;
import org.apache.hadoop.shaded.com.nimbusds.jose.crypto.impl.ContentCryptoProvider;
import org.apache.hadoop.shaded.com.nimbusds.jose.crypto.impl.CriticalHeaderParamsDeferral;
import org.apache.hadoop.shaded.com.nimbusds.jose.crypto.impl.JWEHeaderValidation;
import org.apache.hadoop.shaded.com.nimbusds.jose.crypto.impl.RSA1_5;
import org.apache.hadoop.shaded.com.nimbusds.jose.crypto.impl.RSACryptoProvider;
import org.apache.hadoop.shaded.com.nimbusds.jose.crypto.impl.RSAKeyUtils;
import org.apache.hadoop.shaded.com.nimbusds.jose.crypto.impl.RSA_OAEP;
import org.apache.hadoop.shaded.com.nimbusds.jose.crypto.impl.RSA_OAEP_SHA2;
import org.apache.hadoop.shaded.com.nimbusds.jose.crypto.opts.AllowWeakRSAKey;
import org.apache.hadoop.shaded.com.nimbusds.jose.crypto.opts.CipherMode;
import org.apache.hadoop.shaded.com.nimbusds.jose.crypto.opts.OptionUtils;
import org.apache.hadoop.shaded.com.nimbusds.jose.jwk.RSAKey;
import org.apache.hadoop.shaded.com.nimbusds.jose.shaded.jcip.ThreadSafe;
import org.apache.hadoop.shaded.com.nimbusds.jose.util.Base64URL;

@ThreadSafe
public class RSADecrypter
extends RSACryptoProvider
implements JWEDecrypter,
CriticalHeaderParamsAware {
    private final CriticalHeaderParamsDeferral critPolicy = new CriticalHeaderParamsDeferral();
    private final PrivateKey privateKey;
    private final Set<JWEDecrypterOption> opts;
    private Exception cekDecryptionException;

    public RSADecrypter(PrivateKey privateKey) {
        this(privateKey, null, Collections.emptySet());
    }

    public RSADecrypter(RSAKey rsaJWK) throws JOSEException {
        this(RSAKeyUtils.toRSAPrivateKey(rsaJWK));
    }

    public RSADecrypter(PrivateKey privateKey, Set<String> defCritHeaders) {
        this(privateKey, defCritHeaders, Collections.emptySet());
    }

    @Deprecated
    public RSADecrypter(PrivateKey privateKey, Set<String> defCritHeaders, boolean allowWeakKey) {
        this(privateKey, defCritHeaders, allowWeakKey ? Collections.singleton(AllowWeakRSAKey.getInstance()) : Collections.emptySet());
    }

    public RSADecrypter(PrivateKey privateKey, Set<String> defCritHeaders, Set<JWEDecrypterOption> opts) {
        super(null);
        if (!privateKey.getAlgorithm().equalsIgnoreCase("RSA")) {
            throw new IllegalArgumentException("The private key algorithm must be RSA");
        }
        this.opts = opts != null ? opts : Collections.emptySet();
        OptionUtils.ensureMinRSAPrivateKeySize(privateKey, this.opts);
        this.privateKey = privateKey;
        this.critPolicy.setDeferredCriticalHeaderParams(defCritHeaders);
    }

    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    @Override
    public Set<String> getProcessedCriticalHeaderParams() {
        return this.critPolicy.getProcessedCriticalHeaderParams();
    }

    @Override
    public Set<String> getDeferredCriticalHeaderParams() {
        return this.critPolicy.getProcessedCriticalHeaderParams();
    }

    @Deprecated
    public byte[] decrypt(JWEHeader header, Base64URL encryptedKey, Base64URL iv, Base64URL cipherText, Base64URL authTag) throws JOSEException {
        return this.decrypt(header, encryptedKey, iv, cipherText, authTag, AAD.compute(header));
    }

    private CipherMode resolveCipherModeForOAEP() {
        if (this.opts.contains(CipherMode.ENCRYPT_DECRYPT)) {
            return CipherMode.ENCRYPT_DECRYPT;
        }
        return CipherMode.WRAP_UNWRAP;
    }

    @Override
    public byte[] decrypt(JWEHeader header, Base64URL encryptedKey, Base64URL iv, Base64URL cipherText, Base64URL authTag, byte[] aad) throws JOSEException {
        SecretKey cek;
        if (encryptedKey == null) {
            throw new JOSEException("Missing JWE encrypted key");
        }
        if (iv == null) {
            throw new JOSEException("Missing JWE initialization vector (IV)");
        }
        if (authTag == null) {
            throw new JOSEException("Missing JWE authentication tag");
        }
        this.critPolicy.ensureHeaderPasses(header);
        JWEAlgorithm alg = JWEHeaderValidation.getAlgorithmAndEnsureNotNull(header);
        if (alg.equals(JWEAlgorithm.RSA1_5)) {
            int keyLength = header.getEncryptionMethod().cekBitLength();
            SecretKey randomCEK = ContentCryptoProvider.generateCEK(header.getEncryptionMethod(), this.getJCAContext().getSecureRandom());
            try {
                cek = RSA1_5.decryptCEK(this.privateKey, encryptedKey.decode(), keyLength, this.getJCAContext().getKeyEncryptionProvider());
                if (cek == null) {
                    cek = randomCEK;
                }
            }
            catch (Exception e) {
                this.cekDecryptionException = e;
                cek = randomCEK;
            }
            this.cekDecryptionException = null;
        } else if (alg.equals(JWEAlgorithm.RSA_OAEP)) {
            cek = RSA_OAEP.decryptCEK(this.privateKey, encryptedKey.decode(), this.resolveCipherModeForOAEP(), this.getJCAContext().getKeyEncryptionProvider());
        } else if (alg.equals(JWEAlgorithm.RSA_OAEP_256)) {
            cek = RSA_OAEP_SHA2.decryptCEK(this.privateKey, encryptedKey.decode(), 256, this.resolveCipherModeForOAEP(), this.getJCAContext().getKeyEncryptionProvider());
        } else if (alg.equals(JWEAlgorithm.RSA_OAEP_384)) {
            cek = RSA_OAEP_SHA2.decryptCEK(this.privateKey, encryptedKey.decode(), 384, this.resolveCipherModeForOAEP(), this.getJCAContext().getKeyEncryptionProvider());
        } else if (alg.equals(JWEAlgorithm.RSA_OAEP_512)) {
            cek = RSA_OAEP_SHA2.decryptCEK(this.privateKey, encryptedKey.decode(), 512, this.resolveCipherModeForOAEP(), this.getJCAContext().getKeyEncryptionProvider());
        } else {
            throw new JOSEException(AlgorithmSupportMessage.unsupportedJWEAlgorithm(alg, SUPPORTED_ALGORITHMS));
        }
        return ContentCryptoProvider.decrypt(header, aad, encryptedKey, iv, cipherText, authTag, cek, this.getJCAContext());
    }

    public Exception getCEKDecryptionException() {
        return this.cekDecryptionException;
    }
}

