/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io.erasurecode;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.erasurecode.BufferAllocator;
import org.apache.hadoop.io.erasurecode.ECChunk;
import org.apache.hadoop.io.erasurecode.rawcoder.util.DumpUtil;
import org.junit.Assert;

public abstract class TestCoderBase {
    protected static Random RAND = new Random();
    protected boolean allowDump = true;
    private Configuration conf;
    protected int numDataUnits;
    protected int numParityUnits;
    protected int baseChunkSize;
    private int chunkSize = this.baseChunkSize = 1024;
    private BufferAllocator allocator;
    private byte[] zeroChunkBytes;
    private boolean startBufferWithZero = true;
    protected int[] erasedDataIndexes = new int[]{0};
    protected int[] erasedParityIndexes = new int[]{0};
    protected boolean usingDirectBuffer = true;
    protected boolean usingFixedData = true;
    private static int FIXED_DATA_GENERATOR = 0;
    protected byte[][] fixedData;
    protected boolean allowChangeInputs;

    protected void setChunkSize(int chunkSize) {
        this.chunkSize = chunkSize;
        this.zeroChunkBytes = new byte[chunkSize];
    }

    protected byte[] getZeroChunkBytes() {
        return this.zeroChunkBytes;
    }

    protected void prepareBufferAllocator(boolean usingSlicedBuffer) {
        if (usingSlicedBuffer) {
            int roughEstimationSpace = this.chunkSize * (this.numDataUnits + this.numParityUnits) * 10;
            this.allocator = new BufferAllocator.SlicedBufferAllocator(this.usingDirectBuffer, roughEstimationSpace);
        } else {
            this.allocator = new BufferAllocator.SimpleBufferAllocator(this.usingDirectBuffer);
        }
    }

    protected void prepare(Configuration conf, int numDataUnits, int numParityUnits, int[] erasedDataIndexes, int[] erasedParityIndexes, boolean usingFixedData) {
        int[] nArray;
        int[] nArray2;
        this.conf = conf != null ? conf : new Configuration();
        this.numDataUnits = numDataUnits;
        this.numParityUnits = numParityUnits;
        if (erasedDataIndexes != null) {
            nArray2 = erasedDataIndexes;
        } else {
            int[] nArray3 = new int[1];
            nArray2 = nArray3;
            nArray3[0] = 0;
        }
        this.erasedDataIndexes = nArray2;
        if (erasedParityIndexes != null) {
            nArray = erasedParityIndexes;
        } else {
            int[] nArray4 = new int[1];
            nArray = nArray4;
            nArray4[0] = 0;
        }
        this.erasedParityIndexes = nArray;
        this.usingFixedData = usingFixedData;
        if (usingFixedData) {
            this.prepareFixedData();
        }
    }

    protected void prepare(Configuration conf, int numDataUnits, int numParityUnits, int[] erasedDataIndexes, int[] erasedParityIndexes) {
        this.prepare(conf, numDataUnits, numParityUnits, erasedDataIndexes, erasedParityIndexes, false);
    }

    protected void prepare(int numDataUnits, int numParityUnits, int[] erasedDataIndexes, int[] erasedParityIndexes) {
        this.prepare(null, numDataUnits, numParityUnits, erasedDataIndexes, erasedParityIndexes, false);
    }

    protected Configuration getConf() {
        return this.conf;
    }

    protected void compareAndVerify(ECChunk[] erasedChunks, ECChunk[] recoveredChunks) {
        byte[][] recovered;
        byte[][] erased = this.toArrays(erasedChunks);
        boolean result = Arrays.deepEquals((Object[])erased, (Object[])(recovered = this.toArrays(recoveredChunks)));
        if (!result) {
            Assert.assertTrue((String)"Decoding and comparing failed.", (boolean)result);
        }
    }

    protected int[] getErasedIndexesForDecoding() {
        int i;
        int[] erasedIndexesForDecoding = new int[this.erasedDataIndexes.length + this.erasedParityIndexes.length];
        int idx = 0;
        for (i = 0; i < this.erasedDataIndexes.length; ++i) {
            erasedIndexesForDecoding[idx++] = this.erasedDataIndexes[i];
        }
        for (i = 0; i < this.erasedParityIndexes.length; ++i) {
            erasedIndexesForDecoding[idx++] = this.erasedParityIndexes[i] + this.numDataUnits;
        }
        return erasedIndexesForDecoding;
    }

    protected ECChunk[] prepareInputChunksForDecoding(ECChunk[] dataChunks, ECChunk[] parityChunks) {
        int i;
        ECChunk[] inputChunks = new ECChunk[this.numDataUnits + this.numParityUnits];
        int idx = 0;
        for (i = 0; i < this.numDataUnits; ++i) {
            inputChunks[idx++] = dataChunks[i];
        }
        for (i = 0; i < this.numParityUnits; ++i) {
            inputChunks[idx++] = parityChunks[i];
        }
        return inputChunks;
    }

    protected ECChunk[] backupAndEraseChunks(ECChunk[] dataChunks, ECChunk[] parityChunks) {
        int i;
        ECChunk[] toEraseChunks = new ECChunk[this.erasedDataIndexes.length + this.erasedParityIndexes.length];
        int idx = 0;
        for (i = 0; i < this.erasedDataIndexes.length; ++i) {
            toEraseChunks[idx++] = dataChunks[this.erasedDataIndexes[i]];
            dataChunks[this.erasedDataIndexes[i]] = null;
        }
        for (i = 0; i < this.erasedParityIndexes.length; ++i) {
            toEraseChunks[idx++] = parityChunks[this.erasedParityIndexes[i]];
            parityChunks[this.erasedParityIndexes[i]] = null;
        }
        return toEraseChunks;
    }

    protected void eraseDataFromChunks(ECChunk[] chunks) {
        for (int i = 0; i < chunks.length; ++i) {
            chunks[i] = null;
        }
    }

    protected void markChunks(ECChunk[] chunks) {
        for (int i = 0; i < chunks.length; ++i) {
            if (chunks[i] == null) continue;
            chunks[i].getBuffer().mark();
        }
    }

    protected void restoreChunksFromMark(ECChunk[] chunks) {
        for (int i = 0; i < chunks.length; ++i) {
            if (chunks[i] == null) continue;
            chunks[i].getBuffer().reset();
        }
    }

    protected ECChunk[] cloneChunksWithData(ECChunk[] chunks) {
        ECChunk[] results = new ECChunk[chunks.length];
        for (int i = 0; i < chunks.length; ++i) {
            results[i] = this.cloneChunkWithData(chunks[i]);
        }
        return results;
    }

    protected ECChunk cloneChunkWithData(ECChunk chunk) {
        if (chunk == null) {
            return null;
        }
        ByteBuffer srcBuffer = chunk.getBuffer();
        byte[] bytesArr = new byte[srcBuffer.remaining()];
        srcBuffer.mark();
        srcBuffer.get(bytesArr, 0, bytesArr.length);
        srcBuffer.reset();
        ByteBuffer destBuffer = this.allocateOutputBuffer(bytesArr.length);
        int pos = destBuffer.position();
        destBuffer.put(bytesArr);
        destBuffer.flip();
        destBuffer.position(pos);
        return new ECChunk(destBuffer);
    }

    protected ECChunk allocateOutputChunk() {
        ByteBuffer buffer = this.allocateOutputBuffer(this.chunkSize);
        return new ECChunk(buffer);
    }

    protected ByteBuffer allocateOutputBuffer(int bufferLen) {
        int startOffset = this.startBufferWithZero ? 0 : 11;
        int allocLen = startOffset + bufferLen + startOffset;
        ByteBuffer buffer = this.allocator.allocate(allocLen);
        buffer.limit(startOffset + bufferLen);
        this.fillDummyData(buffer, startOffset);
        this.startBufferWithZero = !this.startBufferWithZero;
        return buffer;
    }

    protected ECChunk[] prepareDataChunksForEncoding() {
        if (this.usingFixedData) {
            ECChunk[] chunks = new ECChunk[this.numDataUnits];
            for (int i = 0; i < chunks.length; ++i) {
                chunks[i] = this.makeChunkUsingData(this.fixedData[i]);
            }
            return chunks;
        }
        return this.generateDataChunks();
    }

    private ECChunk makeChunkUsingData(byte[] data) {
        ECChunk chunk = this.allocateOutputChunk();
        ByteBuffer buffer = chunk.getBuffer();
        int pos = buffer.position();
        buffer.put(data, 0, this.chunkSize);
        buffer.flip();
        buffer.position(pos);
        return chunk;
    }

    private ECChunk[] generateDataChunks() {
        ECChunk[] chunks = new ECChunk[this.numDataUnits];
        for (int i = 0; i < chunks.length; ++i) {
            chunks[i] = this.generateDataChunk();
        }
        return chunks;
    }

    private void prepareFixedData() {
        this.fixedData = new byte[this.numDataUnits][];
        for (int i = 0; i < this.numDataUnits; ++i) {
            this.fixedData[i] = this.generateFixedData(this.baseChunkSize * 2);
        }
    }

    protected ECChunk generateDataChunk() {
        ByteBuffer buffer = this.allocateOutputBuffer(this.chunkSize);
        int pos = buffer.position();
        buffer.put(this.generateData(this.chunkSize));
        buffer.flip();
        buffer.position(pos);
        return new ECChunk(buffer);
    }

    protected void fillDummyData(ByteBuffer buffer, int len) {
        byte[] dummy = new byte[len];
        RAND.nextBytes(dummy);
        buffer.put(dummy);
    }

    protected byte[] generateData(int len) {
        byte[] buffer = new byte[len];
        for (int i = 0; i < buffer.length; ++i) {
            buffer[i] = (byte)RAND.nextInt(256);
        }
        return buffer;
    }

    protected byte[] generateFixedData(int len) {
        byte[] buffer = new byte[len];
        for (int i = 0; i < buffer.length; ++i) {
            buffer[i] = (byte)FIXED_DATA_GENERATOR++;
            if (FIXED_DATA_GENERATOR != 256) continue;
            FIXED_DATA_GENERATOR = 0;
        }
        return buffer;
    }

    protected ECChunk[] prepareParityChunksForEncoding() {
        ECChunk[] chunks = new ECChunk[this.numParityUnits];
        for (int i = 0; i < chunks.length; ++i) {
            chunks[i] = this.allocateOutputChunk();
        }
        return chunks;
    }

    protected ECChunk[] prepareOutputChunksForDecoding() {
        ECChunk[] chunks = new ECChunk[this.erasedDataIndexes.length + this.erasedParityIndexes.length];
        for (int i = 0; i < chunks.length; ++i) {
            chunks[i] = this.allocateOutputChunk();
        }
        return chunks;
    }

    protected byte[][] toArrays(ECChunk[] chunks) {
        byte[][] bytesArr = new byte[chunks.length][];
        for (int i = 0; i < chunks.length; ++i) {
            if (chunks[i] == null) continue;
            bytesArr[i] = chunks[i].toBytesArray();
        }
        return bytesArr;
    }

    protected void dumpSetting() {
        if (this.allowDump) {
            StringBuilder sb = new StringBuilder("Erasure coder test settings:\n");
            sb.append(" numDataUnits=").append(this.numDataUnits);
            sb.append(" numParityUnits=").append(this.numParityUnits);
            sb.append(" chunkSize=").append(this.chunkSize).append("\n");
            sb.append(" erasedDataIndexes=").append(Arrays.toString(this.erasedDataIndexes));
            sb.append(" erasedParityIndexes=").append(Arrays.toString(this.erasedParityIndexes));
            sb.append(" usingDirectBuffer=").append(this.usingDirectBuffer);
            sb.append(" allowChangeInputs=").append(this.allowChangeInputs);
            sb.append(" allowVerboseDump=").append(this.allowDump);
            sb.append("\n");
            System.out.println(sb.toString());
        }
    }

    protected void dumpChunks(String header, ECChunk[] chunks) {
        if (this.allowDump) {
            DumpUtil.dumpChunks((String)header, (ECChunk[])chunks);
        }
    }

    protected void corruptSomeChunk(ECChunk[] chunks) {
        int idx = new Random().nextInt(chunks.length);
        ByteBuffer buffer = chunks[idx].getBuffer();
        if (buffer.hasRemaining()) {
            buffer.position(buffer.position() + 1);
        }
    }

    protected void polluteSomeChunk(ECChunk[] chunks) {
        int idx = new Random().nextInt(chunks.length);
        ByteBuffer buffer = chunks[idx].getBuffer();
        buffer.mark();
        buffer.put((byte)(buffer.get(buffer.position()) + 1));
        buffer.reset();
    }
}

