/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.rx.internal.operators;

import rx.Observable;
import rx.Subscriber;
import rx.functions.Action1;

public final class OperatorDoOnNth<T>
implements Observable.Operator<T, T> {
    private final Action1<? super T> action;
    private final int n;

    public static <T> OperatorDoOnNth<T> create(Action1<? super T> action, int n) {
        return new OperatorDoOnNth<T>(action, n);
    }

    private OperatorDoOnNth(Action1<? super T> action, int n) {
        this.action = action;
        this.n = n;
    }

    public Subscriber<? super T> call(final Subscriber<? super T> child) {
        return new Subscriber<T>(child){
            int count;

            public void onCompleted() {
                child.onCompleted();
            }

            public void onError(Throwable e) {
                child.onError(e);
            }

            public void onNext(T t) {
                ++this.count;
                if (this.count == OperatorDoOnNth.this.n) {
                    OperatorDoOnNth.this.action.call(t);
                }
                child.onNext(t);
            }
        };
    }
}

