/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.statistics.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.apache.hadoop.fs.statistics.impl.IOStatisticsBinding;

final class EvaluatingStatisticsMap<E extends Serializable>
implements Map<String, E> {
    private final Map<String, Function<String, E>> evaluators = new ConcurrentHashMap<String, Function<String, E>>();
    private final Function<E, E> copyFn;

    EvaluatingStatisticsMap() {
        this(IOStatisticsBinding::passthroughFn);
    }

    EvaluatingStatisticsMap(Function<E, E> copyFn) {
        this.copyFn = copyFn;
    }

    void addFunction(String key, Function<String, E> eval) {
        this.evaluators.put(key, eval);
    }

    @Override
    public int size() {
        return this.evaluators.size();
    }

    @Override
    public boolean isEmpty() {
        return this.evaluators.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.evaluators.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public E get(Object key) {
        Function<String, E> fn = this.evaluators.get(key);
        return (E)(fn != null ? (Serializable)fn.apply((String)key) : null);
    }

    @Override
    public E put(String key, E value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public E remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(Map<? extends String, ? extends E> m) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<String> keySet() {
        return this.evaluators.keySet();
    }

    @Override
    public Collection<E> values() {
        ArrayList result = new ArrayList(this.size());
        this.evaluators.forEach((? super K k, ? super V f) -> result.add(f.apply(k)));
        return result;
    }

    public Map<String, E> snapshot() {
        return IOStatisticsBinding.snapshotMap(this, this.copyFn);
    }

    @Override
    public Set<Map.Entry<String, E>> entrySet() {
        LinkedHashSet result = new LinkedHashSet(this.size());
        this.evaluators.forEach((? super K key, ? super V evaluator) -> {
            Serializable current = (Serializable)evaluator.apply(key);
            result.add(new EntryImpl((String)key, current));
        });
        return result;
    }

    @Override
    public void forEach(BiConsumer<? super String, ? super E> action) {
        BiConsumer<String, Function> biConsumer = (key, value) -> action.accept((String)key, (Object)value.apply(key));
        this.evaluators.forEach(biConsumer);
    }

    private static final class EntryImpl<E>
    implements Map.Entry<String, E> {
        private final String key;
        private E value;

        private EntryImpl(String key, E value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public String getKey() {
            return this.key;
        }

        @Override
        public E getValue() {
            return this.value;
        }

        @Override
        public E setValue(E val) {
            this.value = val;
            return val;
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)o;
            return Objects.equals(this.key, entry.getKey()) && Objects.equals(this.value, entry.getValue());
        }

        @Override
        public int hashCode() {
            return Objects.hashCode(this.key);
        }
    }
}

