/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.streaming.io;

import java.io.ByteArrayOutputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.streaming.PipeMapRed;
import org.apache.hadoop.streaming.io.InputWriter;

public class RawBytesInputWriter
extends InputWriter<Writable, Writable> {
    private DataOutput clientOut;
    private ByteArrayOutputStream bufferOut;
    private DataOutputStream bufferDataOut;

    @Override
    public void initialize(PipeMapRed pipeMapRed) throws IOException {
        super.initialize(pipeMapRed);
        this.clientOut = pipeMapRed.getClientOutput();
        this.bufferOut = new ByteArrayOutputStream();
        this.bufferDataOut = new DataOutputStream(this.bufferOut);
    }

    @Override
    public void writeKey(Writable key) throws IOException {
        this.writeRawBytes(key);
    }

    @Override
    public void writeValue(Writable value) throws IOException {
        this.writeRawBytes(value);
    }

    private void writeRawBytes(Writable writable) throws IOException {
        if (writable instanceof BytesWritable) {
            BytesWritable bw = (BytesWritable)writable;
            byte[] bytes = bw.getBytes();
            int length = bw.getLength();
            this.clientOut.writeInt(length);
            this.clientOut.write(bytes, 0, length);
        } else {
            this.bufferOut.reset();
            writable.write((DataOutput)this.bufferDataOut);
            byte[] bytes = this.bufferOut.toByteArray();
            this.clientOut.writeInt(bytes.length);
            this.clientOut.write(bytes);
        }
    }
}

