/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.functions.scalar;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.data.binary.BinaryStringData;
import org.apache.flink.table.data.binary.BinaryStringDataUtil;
import org.apache.flink.table.functions.BuiltInFunctionDefinitions;
import org.apache.flink.table.functions.SpecializedFunction;
import org.apache.flink.table.runtime.functions.scalar.BuiltInScalarFunction;
import org.apache.flink.table.utils.ThreadLocalCache;

@Internal
public class TranslateFunction
extends BuiltInScalarFunction {
    private static final ThreadLocalCache<Pair<String, String>, Map<Integer, String>> DICT_CACHE = new ThreadLocalCache<Pair<String, String>, Map<Integer, String>>(){

        public Map<Integer, String> getNewInstance(Pair<String, String> key) {
            return TranslateFunction.buildDict((String)key.getLeft(), (String)key.getRight());
        }
    };

    public TranslateFunction(SpecializedFunction.SpecializedContext context) {
        super(BuiltInFunctionDefinitions.TRANSLATE, context);
    }

    @Nullable
    public StringData eval(@Nullable StringData expr, @Nullable StringData fromStr, @Nullable StringData toStr) {
        if (expr == null || fromStr == null || BinaryStringDataUtil.isEmpty((BinaryStringData)expr) || BinaryStringDataUtil.isEmpty((BinaryStringData)fromStr)) {
            return expr;
        }
        String source = expr.toString();
        String from = fromStr.toString();
        String to = toStr == null ? "" : toStr.toString();
        Map dict = (Map)DICT_CACHE.get((Object)Pair.of((Object)from, (Object)to));
        return BinaryStringData.fromString((String)this.translate(source, dict));
    }

    private String translate(String expr, Map<Integer, String> dict) {
        int charCount;
        StringBuilder res = new StringBuilder();
        for (int i = 0; i < expr.length(); i += charCount) {
            int codePoint = expr.codePointAt(i);
            charCount = Character.charCount(codePoint);
            String ch = dict.get(codePoint);
            if (ch == null) {
                res.append(expr, i, i + charCount);
                continue;
            }
            res.append(ch);
        }
        return res.toString();
    }

    private static Map<Integer, String> buildDict(String from, String to) {
        int fromCodePoint;
        HashMap<Integer, String> hashDict = new HashMap<Integer, String>();
        int j = 0;
        for (int i = 0; i < from.length(); i += Character.charCount(fromCodePoint)) {
            int toCodePoint = -1;
            int toCharCount = 1;
            if (j < to.length()) {
                toCodePoint = to.codePointAt(j);
                toCharCount = Character.charCount(toCodePoint);
                j += toCharCount;
            }
            fromCodePoint = from.codePointAt(i);
            if (hashDict.containsKey(fromCodePoint)) continue;
            hashDict.put(fromCodePoint, toCodePoint == -1 ? "" : to.substring(j - toCharCount, j));
        }
        return hashDict;
    }
}

